package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import org.hibernate.Query;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.SurrogateDao;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Surrogate;

public class SurrogateDaoImpl extends BaseEntityDaoHibernate<Surrogate, Long> 
	implements SurrogateDao {

	@SuppressWarnings("unchecked")
	public List<Surrogate> getSurrogatesFor(Clinician c){
		String[] paramNames = new String[] { "userId" }; 
		Object[] paramValues = new Object[] { c.getId()}; 
		
		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				SurrogateDao.QRY_GET_SURROGATE_FOR_USER, paramNames, paramValues );
	}
	
	
	/*
	 *  Get Current Surrogate by user
	 *  @param userId
	 *  @return Surrogate
	 */
	@SuppressWarnings("unchecked")
	public Surrogate getCurrentSurrogateFor(Clinician c){
		String[] paramNames = new String[] { "userId" }; 
		Object[] paramValues = new Object[] { c.getId()}; 
		
		
		List<Surrogate> surrogateList =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				SurrogateDao.QRY_GET_CURRENT_SURROGATE_FOR_USER, paramNames, paramValues );
		
		if(surrogateList!=null && surrogateList.size()>0)
			return (Surrogate)surrogateList.get(0);
		else
			return null;
	}
	
	/*
	 *  Delete All Surrogate By User
	 *  @param userId
	 *  @return Boolean
	 */
	@SuppressWarnings("unchecked")
	public int clearSurrogatesFor(Clinician c){
		String[] paramNames = new String[] { "userId" }; 
		Object[] paramValues = new Object[] { c.getId()}; 

		Query q = getSession().getNamedQuery(SurrogateDao.QRY_DELETE_SURROAGE_BY_USER);
		String sql = q.getQueryString();

		return getHibernateTemplate().bulkUpdate(sql, paramValues);
		
	}
	
	public List<Surrogate> findClinicansWithTriageGroupSurrogate(Long tgId){
		String[] paramNames = new String[] { "tgId" }; 
		Object[] paramValues = new Object[] { tgId }; 
		
		List<Surrogate> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				SurrogateDao.QRY_CLINICIANS_WITH_TG_SURROGATE, paramNames, paramValues );
		return l;
		
	}
	
}

