package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.StationTimezoneDao;
import gov.va.med.mhv.sm.model.StationTimezone;

public class StationTimezoneDaoImpl extends BaseEntityDaoHibernate<StationTimezone, Long> 
	implements StationTimezoneDao {
	
	
	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(StationTimezoneDaoImpl.class);
	
	@SuppressWarnings("unchecked")
	public StationTimezone getTimezoneForStation(String stationNo){
		
		
		String[] paramNames = new String[] { "stationNo" }; 
		Object[] paramValues = new Object[] { stationNo }; 
		
		List<StationTimezone> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_TIMEZONE_FOR_STATION, paramNames, paramValues );
		
		if(l == null || l.size() == 0) return null;
		
		if(l.size() > 1){
			// since we can't know which is right log a warning, 
			// return null and let the service layer use a default
			if(log.isWarnEnabled()){
				log.warn("duplicate records exist in timezone map for stationNo: " + stationNo);
			}
			return null;
		}
		
		return l.get(0);
	}
	
	
	

}
