package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import org.hibernate.LockMode;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.SignatureDao;
import gov.va.med.mhv.sm.model.Signature;

public class SignatureDaoImpl extends BaseEntityDaoHibernate<Signature, Long> 
	implements SignatureDao {

	@SuppressWarnings("unchecked")
	public List<Signature> getSignatureForUser(Long userId){
		String[] paramNames = new String[] { "userId" }; 
		Object[] paramValues = new Object[] { userId}; 
		
		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				SignatureDao.QRY_GET_SIGNATURE_FOR_USER, paramNames, paramValues );
	}
	
	
	public void fleshObject(Signature s)
	{
		getSession().lock(s,LockMode.NONE);
		getHibernateTemplate().initialize(s.getUser());
	}
	
}

