package gov.va.med.mhv.sm.dao.hibernate;

import gov.va.med.mhv.sm.dao.ReportsDao;
import gov.va.med.mhv.sm.service.impl.ReportsServiceImpl;

import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;


/**
 * @author DNS   MCCARW
 *
 */
public class ReportsDaoImpl extends HibernateDaoSupport implements ReportsDao {
	private static final Log log = LogFactory.getLog(ReportsDaoImpl.class);

	public List<Object[]> getCountReportsDataForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period,List<Long> subCategories){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period", "subCategories" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period, subCategories }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getCountReportsDataForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period,List<Long> subCategories){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period","subCategories" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period,  subCategories };
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getCountReportsDataForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period,List subCategories){
		String[] paramNames = new String[] { "start", "end", "visnId", "period","subCategories" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period, subCategories }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getCountReportsDataForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period,List subCategories){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period","subCategories" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period, subCategories }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getCountReportsDataForAllVisns(Date start,Date end,String period,List subCategories){
		String[] paramNames = new String[] { "start", "end", "period","subCategories" }; 
		Object[] paramValues = new Object[] { start, end, period, subCategories }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getCountReportsDataForOneVisn(Date start,Date end,Long visnId,String period,List subCategories){
		String[] paramNames = new String[] { "start", "end", "visnId", "period","subCategories" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period, subCategories }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	
	/*
	 * Counts live data searches begins here: Unique Patient Senders
	 */
	public List<Object[]> getCountReportsDataUniquePatientSendersForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_PATIENT_SENDERS_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniquePatientSendersForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period"}; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period };
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_PATIENT_SENDERS_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniquePatientSendersForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_PATIENT_SENDERS_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniquePatientSendersForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_PATIENT_SENDERS_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniquePatientSendersForAllVisns(Date start,Date end,String period){
		String[] paramNames = new String[] { "start", "end", "period" }; 
		Object[] paramValues = new Object[] { start, end, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_PATIENT_SENDERS_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniquePatientSendersForOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_PATIENT_SENDERS_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}
	/*
	 * Counts live data searches begins here: Unique Team Member Senders
	 */
	public List<Object[]> getCountReportsDataUniqueMemberSendersForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_MEMBER_SENDERS_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniqueMemberSendersForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period"}; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period };
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_MEMBER_SENDERS_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniqueMemberSendersForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_MEMBER_SENDERS_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniqueMemberSendersForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_MEMBER_SENDERS_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniqueMemberSendersForAllVisns(Date start,Date end,String period){
		String[] paramNames = new String[] { "start", "end", "period" }; 
		Object[] paramValues = new Object[] { start, end, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_MEMBER_SENDERS_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
	}
	public List<Object[]> getCountReportsDataUniqueMemberSendersForOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_UNIQUE_MEMBER_SENDERS_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	/**
	 * 
	 * Counts Live Data for OptedIn Patients 
	 *
	 */
	public List<Object[]> getCountReportsDataOptedInPatientsForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_IN_PATIENTS_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedInPatientsForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_IN_PATIENTS_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}

	
	public List<Object[]> getCountReportsDataOptedInPatientsForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_IN_PATIENTS_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedInPatientsForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_IN_PATIENTS_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedInPatientsForAllVisns(Date start,Date end,String period){
		String[] paramNames = new String[] { "start", "end", "period" }; 
		Object[] paramValues = new Object[] { start, end, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_IN_PATIENTS_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedInPatientsForOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_IN_PATIENTS_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}

	
	/**
	 * 
	 * Counts Live Data for Blocked Patient
	 *
	 */
	public List<Object[]> getCountReportsDataBlockedPatientsForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_BLOCKED_PATIENTS_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataBlockedPatientsForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_BLOCKED_PATIENTS_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getCountReportsDataBlockedPatientsForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_BLOCKED_PATIENTS_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataBlockedPatientsForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_BLOCKED_PATIENTS_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataBlockedPatientsForAllVisns(Date start,Date end,String period){
		String[] paramNames = new String[] { "start", "end", "period" }; 
		Object[] paramValues = new Object[] { start, end, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_BLOCKED_PATIENTS_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataBlockedPatientsForOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_BLOCKED_PATIENTS_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	/**
	 * 
	 * Counts Live Data for OptedOut Patients 
	 *
	 */
	public List<Object[]> getCountReportsDataOptedOutPatientsForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_OUT_PATIENTS_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedOutPatientsForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_OUT_PATIENTS_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}

	
	public List<Object[]> getCountReportsDataOptedOutPatientsForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_OUT_PATIENTS_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedOutPatientsForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_OUT_PATIENTS_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedOutPatientsForAllVisns(Date start,Date end,String period){
		String[] paramNames = new String[] { "start", "end", "period" }; 
		Object[] paramValues = new Object[] { start, end, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_OUT_PATIENTS_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataOptedOutPatientsForOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_OPTED_OUT_PATIENTS_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}

	
	/**
	 * 
	 * Counts Live Data for Action Pending Patients 
	 *
	 */
	public List<Object[]> getCountReportsDataActionPendingPatientsForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_ACTION_PENDING_PATIENTS_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataActionPendingPatientsForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_ACTION_PENDING_PATIENTS_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}

	
	public List<Object[]> getCountReportsDataActionPendingPatientsForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_ACTION_PENDING_PATIENTS_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataActionPendingPatientsForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_ACTION_PENDING_PATIENTS_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataActionPendingPatientsForAllVisns(Date start,Date end,String period){
		String[] paramNames = new String[] { "start", "end", "period" }; 
		Object[] paramValues = new Object[] { start, end, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_ACTION_PENDING_PATIENTS_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataActionPendingPatientsForOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_ACTION_PENDING_PATIENTS_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}


	
	
	/**
	 * 
	 * Counts Report Data for Education Category 
	 *
	 */
	public List<Object[]> getCountReportsDataEducationCategoryForAllTeamsByOneFacility(Date start,Date end,Long stationNumber,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_EDUCATION_CATEGORY_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataEducationCategoryForOneTeamAndOneFacility(Date start,Date end,Long stationNumber,Long triageGroupId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "triageGroupId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, triageGroupId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_EDUCATION_CATEGORY_FOR_ONE_TEAM_AND_ONE_FACILITY, paramNames, paramValues );
		return l;
	}

	
	public List<Object[]> getCountReportsDataEducationCategoryForAllFacilitiesByOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_EDUCATION_CATEGORY_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataEducationCategoryForOneFacilityAndOneVisn(Date start,Date end,Long stationNumber,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "stationNumber", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, stationNumber, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_EDUCATION_CATEGORY_FOR_ONE_FACILITY_AND_ONE_VISN, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataEducationCategoryForAllVisns(Date start,Date end,String period){
		String[] paramNames = new String[] { "start", "end", "period" }; 
		Object[] paramValues = new Object[] { start, end, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_EDUCATION_CATEGORY_FOR_ALL_VISNS, paramNames, paramValues );
		return l;
		
	}
	
	public List<Object[]> getCountReportsDataEducationCategoryForOneVisn(Date start,Date end,Long visnId,String period){
		String[] paramNames = new String[] { "start", "end", "visnId", "period" }; 
		Object[] paramValues = new Object[] { start, end, visnId, period }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_COUNT_REPORTS_DATA_EDUCATION_CATEGORY_FOR_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	
	/*
	 *  List Reports methods Starts here
	 * @see gov.va.med.mhv.sm.dao.ReportsDao#getListsHealthcareTeamsDataForOneVisn(java.lang.Long)
	 */
	public List<Object[]> getListsHealthcareTeamsDataForAllFacilitiesByOneVisn(Long visnId){
		String[] paramNames = new String[] { "visnId" }; 
		Object[] paramValues = new Object[] { visnId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_HEALTHCARE_TEAMS_DATA_FOR_ALL_FACILITIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getListsHealthcareTeamsDataForOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" }; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_HEALTHCARE_TEAMS_DATA_FOR_ONE_FACILITY, paramNames, paramValues );
		return l;	
	}
	
	/* Facility Level Report */
	public List<Object[]> getListsHealthcareTeamsDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" }; 
		Object[] paramValues = new Object[] { triageGroupId.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_HEALTHCARE_TEAMS_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;	
	}
	
	/* Facility Level Report */
	public List<Object[]> getListsHealthcareTeamsDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber"}; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_HEALTHCARE_TEAMS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;	
	}
	
	
	
	public List<Object[]> getListsHealthcareTeamMembersDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId"}; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_HEALTHCARE_TEAMMEMBERS_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;	
	}

	
	public List<Object[]> getListsHealthcareTeamMembersDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber"}; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_HEALTHCARE_TEAMMEMBERS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsBlockedPatientsDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId"}; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_BLOCKED_PATIENTS_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getListsBlockedPatientsDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber"}; 
		Object[] paramValues = new Object[] { stationNumber.toString()}; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_BLOCKED_PATIENTS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getListsBlockedPatientsDataForOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber"}; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_BLOCKED_PATIENTS_DATA_FOR_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getListsBlockedPatientsDataForAllFacilitiesByOneVisn(Long visnId){
		String[] paramNames = new String[] { "visnId"}; 
		Object[] paramValues = new Object[] { visnId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_BLOCKED_PATIENTS_DATA_FOR_ALL_FACILTIES_BY_ONE_VISN, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getListsOptedInPatientsDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId"}; 
		Object[] paramValues = new Object[] { triageGroupId}; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_OPTED_IN_PATIENTS_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getListsOptedInPatientsDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber"}; 
		Object[] paramValues = new Object[] { stationNumber.toString()}; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_OPTED_IN_PATIENTS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsOptedOutPatientsDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId"}; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_OPTED_OUT_PATIENTS_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsOptedOutPatientsDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" }; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_OPTED_OUT_PATIENTS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsActionPendingPatientsDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" }; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_ACTION_PENDING_PATIENTS_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsActionPendingPatientsDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" }; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_ACTION_PENDING_PATIENTS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;
	}
	
	public List<Object[]> getListsAssociatedPatientsDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" }; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_ASSOCIATED_PATIENTS_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsAssociatedPatientsDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" }; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_ASSOCIATED_PATIENTS_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsCPRSTiuFailureDataForOneTeam(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" }; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_CPRS_TIU_FAILURE_DATA_FOR_ONE_TEAM, paramNames, paramValues );
		return l;	
	}
	
	public List<Object[]> getListsCPRSTiuFailureDataForAllTeamsByOneFacility(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" }; 
		Object[] paramValues = new Object[] { stationNumber.toString() }; 
		logParameters(paramNames,paramValues);
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				ReportsDao.QRY_GET_LISTS_CPRS_TIU_FAILURE_DATA_FOR_ALL_TEAMS_BY_ONE_FACILITY, paramNames, paramValues );
		return l;	
	}
	

	
	public List getLastReportDataRefreshDate(){
		List l = getHibernateTemplate().findByNamedQuery(ReportsDao.QRY_GET_LAST_REPORT_REFRESH_DATE);
		return l;
	}

	private void logParameters(String[] paramNames, Object[] paramValues) {
		if(log.isInfoEnabled()) {
			for(int i=0;i<paramNames.length;i++) {
				log.info("Param: "+paramNames[i]+", value: '"+String.valueOf(paramValues[i]) +"'");
			}
		}
	}
	
	
	
}
