package gov.va.med.mhv.sm.dao.hibernate;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.ReAssignMessageDao;
import gov.va.med.mhv.sm.enumeration.ReAssignMessageActionEnum;
import gov.va.med.mhv.sm.model.Holiday;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessageAttachment;
import gov.va.med.mhv.sm.model.ReAssignMessageHistory;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReAssignMessageDaoImpl extends BaseEntityDaoHibernate<ReAssignMessageHistory, Long> implements ReAssignMessageDao {
	
	private ReAssignMessageDao reAssignMessageDao;
	

	@SuppressWarnings("unused")
	public ReAssignMessageHistory findMessageById(Long id){
		
		return reAssignMessageDao.findById(id);	
	}
	
	
	public ReAssignMessageDao getReAssignMessageDao() {
		return reAssignMessageDao;
	}

	public void setReAssignMessageDao(ReAssignMessageDao reAssignMessageDao) {
		this.reAssignMessageDao = reAssignMessageDao;
	}

	
	public Boolean findMessageReceivedHistoryByMessage(Long secureMessageId){
		String[] paramNames = new String[] { "secureMessageId" }; 
		Object[] paramValues = new Object[] { secureMessageId }; 
		
		List<Message> l = getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_FIND_RECEIVED_HISTORY_ACTION_BY_MESSAGE, paramNames, paramValues );
		
		if(l!=null && l.size()>0)
			return Boolean.TRUE; 
		else
			return Boolean.FALSE;
	}
	
	public ReAssignMessageHistory getMsgHistoryByMsgAndAction(Long secureMessageId, ReAssignMessageActionEnum action){
		
		String[] paramNames = new String[] { "secureMessageId","action" }; 
		Object[] paramValues = new Object[] { secureMessageId, action }; 
		
		List<ReAssignMessageHistory> historyList = getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_GET_HISTORY_BY_MESSAGE_AND_ACTION, paramNames, paramValues );
		if(historyList!=null && historyList.size()>0)
			return historyList.get(0);
		else
			return null;
	}
	
	public Collection<ReAssignMessageHistory> getReAssignMessageHistoryByMessage(Long secureMessageId){
		
		String[] paramNames = new String[] { "secureMessageId"}; 
		Object[] paramValues = new Object[] { secureMessageId}; 
		
		Collection<ReAssignMessageHistory> reAssignHistoryList = getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_GET_REASSIGN_HISTORY_BY_MESSAGE, paramNames, paramValues );

		return reAssignHistoryList;	
	}
	
	
	public ReAssignMessageHistory  getAutoAssociatedTGHistoryByMessage(Long secureMessageId){
		String[] paramNames = new String[] { "secureMessageId" }; 
		Object[] paramValues = new Object[] { secureMessageId }; 
		
		List<ReAssignMessageHistory> historyList = getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_GET_AUTO_ASSOCIATED_TG_HISTORY_BY_MESSAGE, paramNames, paramValues );
		if(historyList!=null && historyList.size()>0)
			return historyList.get(0);
		else
			return null;
		
	}
	
}
