package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.ReAssignFacilityDao;
import gov.va.med.mhv.sm.model.PatientReassignFacility;
import gov.va.med.mhv.sm.model.SMWorkloadHistorical;


public class ReAssignFacilityDaoImpl extends BaseEntityDaoHibernate<PatientReassignFacility, Long> 
	implements ReAssignFacilityDao {

	
	@SuppressWarnings("unchecked")
	public PatientReassignFacility getPatientReassignFacilityByStationAndPatient(Long stationNumber,Long patientId){
		String[] paramNames = new String[] { "stationNumber","patientId" }; 
		Object[] paramValues = new Object[] { stationNumber, patientId };
		
		@SuppressWarnings("unchecked")
		List<PatientReassignFacility> patientReassignFacility =  getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_PATIENT_REASSIGN_FACILITY_STATION_AND_PATIENT, paramNames, paramValues );
		
		if(patientReassignFacility!=null && patientReassignFacility.size()!=0){
			return patientReassignFacility.get(0);
		}
		return null ;
	}
	
	@SuppressWarnings("unchecked")
	public List<Object[]> getPatientReassignFacilityByStation(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" }; 
		Object[] paramValues = new Object[] { stationNumber }; 
		
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_PATIENT_REASSIGN_FACILITY_STATION, paramNames, paramValues );
		
		return l;	
	}
	
}

