package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.PatientTriageMapDao;
import gov.va.med.mhv.sm.model.PatientTriageMap;


public class PatientTriageMapDaoImpl extends BaseEntityDaoHibernate<PatientTriageMap, Long> 
	implements PatientTriageMapDao {

	 
	@SuppressWarnings("unchecked")
	public PatientTriageMap find(Long relationId, Long patientId){
		
		String[] paramNames = new String[] { "relationId", "patientId" }; 
		Object[] paramValues = new Object[] { relationId, patientId }; 
		
		List<PatientTriageMap> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_PATIENT_TRIAGE_BY_IDS, paramNames, paramValues );
		
		if(l == null || l.size() == 0){
			return null;
		}
		
		return l.get(0);
	}
	
	@SuppressWarnings("unchecked")
	public void delete(Long relationId, Long patientId){
		
		PatientTriageMap ptm = find(relationId, patientId);
		if(ptm != null) delete(ptm.getId());
		
	}
	
	
	
}
