package gov.va.med.mhv.sm.dao.hibernate;

import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.PatientBlockedTriageGroupDao;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.service.impl.PatientBlockedServiceImpl;


public class PatientBlockedTriageGroupDaoImpl extends BaseEntityDaoHibernate<PatientBlockedTriageGroup, Long> 
	implements PatientBlockedTriageGroupDao {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(PatientBlockedTriageGroupDaoImpl.class);
	
	@SuppressWarnings("unchecked")
	public void clearPatientBlockedTriageGroupByPatientIdAndStation(Long patientId, Long stationNumber){
		Collection<PatientBlockedTriageGroup> blockedPatientList = getBlockedPatientsListByPatientIdAndStation(patientId,stationNumber);
		if(blockedPatientList!=null && blockedPatientList.size()>0){
			getHibernateTemplate().deleteAll(blockedPatientList);
			if(log.isInfoEnabled()){
				log.info(">>>>>>PatientBlockedTriageGroupImpl->Blocked Patient Triage Group Deleted Successfully patientId..."+patientId+"^ Station.."+stationNumber);
			}
		}
	}
	
	public void clearPatientBlockedTriageGroupByPatientId(Long patientId){
		Collection<PatientBlockedTriageGroup> blockedPatientList = getPatientBlockedTriageGroupsByPatientId(patientId);
		if(blockedPatientList!=null && blockedPatientList.size()>0){
			getHibernateTemplate().deleteAll(blockedPatientList);
			if(log.isInfoEnabled()){
				log.info(">>>>>>PatientBlockedTriageGroupImpl->Override Patient Blocked Tgs by patientId..."+patientId);
			}	
		}
	}
	
	public Collection<PatientBlockedTriageGroup> getBlockedPatientsListByPatientIdAndStation(Long patientId, Long stationNumber){
		String[] paramNames = new String[] { "patientId","stationNumber" }; 
		Object[] paramValues = new Object[] { patientId, stationNumber }; 
		
		Collection<PatientBlockedTriageGroup> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_PATIENTS_LIST_BY_PATIENTID_AND_STATION, paramNames, paramValues );
		
		return l;
	}

	@SuppressWarnings("unchecked")
	public List<Object[]>  getPatientBlockedTriageGroupsByPatientIdAndStation(Long patientId,Long stationNumber){
		String[] paramNames = new String[] { "patientId","stationNumber" }; 
		Object[] paramValues = new Object[] { patientId, stationNumber }; 
		
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_PATIENT_BLOCKED_TGS_BY_PATIENTIDANDSTATION, paramNames, paramValues );
		
		return l;
	}
	
	@SuppressWarnings("unchecked")
	public List<Object[]>  getBlockedPatientsDetailsByTriageGroupId(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" }; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_PATIENTS_DETAILS_BY_TRIAGEGROUP_ID, paramNames, paramValues );
		
		return l;
	}

	@SuppressWarnings("unchecked")
	public Collection<PatientBlockedTriageGroup> getPatientBlockedTriageGroupsByPatientId(Long patientId){
		String[] paramNames = new String[] { "patientId" }; 
		Object[] paramValues = new Object[] { patientId }; 
		
		Collection<PatientBlockedTriageGroup> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_PATIENTTRIAGEGROUPS_BY_PATIENT_ID, paramNames, paramValues );
		return l;
	}
	
	@SuppressWarnings("unchecked")
	public PatientBlockedTriageGroup getPatientBlockedTriageGroupByTgIdAndPatientId(Long triageGroupId,Long patientId){
		String[] paramNames = new String[] { "triageGroupId","patientId" }; 
		Object[] paramValues = new Object[] { triageGroupId, patientId }; 
		
		List<PatientBlockedTriageGroup> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_PATIENTTRIAGEGROUP_BY_TG_ID_AND_PATIENT_ID, paramNames, paramValues );
		
		if (l !=null && l.size() !=0) {
			return l.get(0);
		}
		return null;
	}
	
	@SuppressWarnings("unchecked")
	public Collection<PatientBlockedTriageGroup> getBlockedPatientsByTriageGroupId(Long triageGroupId){
		String[] paramNames = new String[] { "triageGroupId" }; 
		Object[] paramValues = new Object[] { triageGroupId }; 
		
		Collection<PatientBlockedTriageGroup> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_PATIENTS_BY_TRIAGEGROUP_ID, paramNames, paramValues );
		return l;
	}
}

