package gov.va.med.mhv.sm.dao.hibernate;

import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.PatientBlockedFacilityDao;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.service.impl.PatientBlockedServiceImpl;


public class PatientBlockedFacilityDaoImpl extends BaseEntityDaoHibernate<PatientBlockedFacility, Long>
	implements PatientBlockedFacilityDao {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(PatientBlockedFacilityDaoImpl.class);

	@SuppressWarnings("unchecked")
	public void clearPatientBlockedFacilityByPatientIdAndStation(Long patientId, Long stationNumber){
		Collection<PatientBlockedFacility> blockedPatientList = getBlockedFacilityPatientsByPatientIdAndStation(patientId,stationNumber);
		if(blockedPatientList!=null && blockedPatientList.size()>0){
			getHibernateTemplate().deleteAll(blockedPatientList);
			if(log.isInfoEnabled()){
				log.info(">>>>>>PatientBlockedFacilityImpl->Blocked Patient Facility Deleted Successfully patientId..."+patientId+"^ Station.."+stationNumber);
			}
		}
	}


	@SuppressWarnings("unchecked")
	public List<Object[]>  getPatientBlockedFacilityByPatientIdAndStation(Long patientId,Long stationNumber){
		String[] paramNames = new String[] { "patientId","stationNumber" };
		Object[] paramValues = new Object[] { patientId, stationNumber };

		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_FACILITY_PATIENTS_DETAILS_BY_PATIENTID_AND_STATION, paramNames, paramValues );

		return l;
	}


	@SuppressWarnings("unchecked")
	public List<Object[]>  getBlockedFacilityPatientsDetailsByStation(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" };
		Object[] paramValues = new Object[] { stationNumber };

		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_FACILITY_PATIENTS_DETAILS_BY_STATION, paramNames, paramValues );

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<Object[]>  getBlockedFacilityPatientsDetailsByPatientId(Long patientId){
		String[] paramNames = new String[] { "patientId" };
		Object[] paramValues = new Object[] { patientId };

		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_FACILITY_PATIENTS_DETAILS_BY_PATIENT_ID, paramNames, paramValues );

		return l;
	}

	@SuppressWarnings("unchecked")
	public Collection<PatientBlockedFacility> getBlockedFacilityPatientsByPatientIdAndStation(Long patientId,Long stationNumber){
		String[] paramNames = new String[] { "patientId","stationNumber" };
		Object[] paramValues = new Object[] { patientId, stationNumber };

		Collection<PatientBlockedFacility> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_FACILITY_PATIENTS_BY_PATIENTID_AND_STATION, paramNames, paramValues );
		return l;
	}

	@SuppressWarnings("unchecked")
	public Collection<PatientBlockedFacility> getBlockedFacilityPatientsByStation(Long stationNumber){
		String[] paramNames = new String[] { "stationNumber" };
		Object[] paramValues = new Object[] { stationNumber };

		Collection<PatientBlockedFacility> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_FACILITY_PATIENTS_BY_STATION, paramNames, paramValues );
		return l;
	}


	@SuppressWarnings("unchecked")
	public Collection<PatientBlockedFacility> getBlockedFacilitiesByPatientId(Long patientId){
		String[] paramNames = new String[] { "patientId" };
		Object[] paramValues = new Object[] { patientId };

		Collection<PatientBlockedFacility> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_BLOCKED_FACILITIES_BY_PATIENT_ID, paramNames, paramValues );
		return l;
	}
}
