package gov.va.med.mhv.sm.dao.hibernate;


import java.util.Date;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.Query;

import gov.va.med.mhv.foundation.util.CalendarUtils;
import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.MessageDao;
import gov.va.med.mhv.sm.model.Message;


public class MessageDaoImpl extends BaseEntityDaoHibernate<Message, Long> 
	implements MessageDao {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(MessageDaoImpl.class);
	
	public MessageDaoImpl(){
		
	}
	
	@SuppressWarnings("unused")
	private Date getLastYear(){
		int year = Integer.parseInt(CalendarUtils.getCurrentYear());
		return CalendarUtils.getDate(
				CalendarUtils.getCurrentMonth(), CalendarUtils.getCurrentDay(), 
				Integer.toString(year - 1));
	}
	
	public void fillThread(Message m){
		try{
			getSession().lock(m,LockMode.NONE);
			getHibernateTemplate().initialize(m.getThread());
		}catch(Exception e){
			/* no op */
		}
		
	}

	public Message getMessageComplete(Long id){
		
		Message m = null;
		try {
			m = this.findById(id);
			getHibernateTemplate().initialize(m.getThread());
			getHibernateTemplate().initialize(m.getThread().getMessages());
			getHibernateTemplate().initialize(m.getThread().getAnnotations());
			getHibernateTemplate().initialize(m.getAssignedTo());
			List<Message> l = m.getThread().getMessages();
			for (Message x : l) {
				getHibernateTemplate().initialize(x.getAddressees());
			}
		} catch (Exception e) {
			/* no op */
		}
		return m;
		
	}
	
	public int escalateMessages(Date escalationDate){
		
		Object[] paramValues = new Object[] { new Date(), new Date(), escalationDate}; 
		
		Query q = getSession().getNamedQuery(QRY_ESCALATE_MESSAGES);
		String sql = q.getQueryString();
		
		return getHibernateTemplate().bulkUpdate(sql, paramValues);
	}
	

	public List<Message> getMessagesToEscalateByDate(Date escalateDate){
		String[] paramNames = new String[] { "escalateDate" }; 
		Object[] paramValues = new Object[] { escalateDate }; 
		
		List<Message> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_GET_MESSAGES_TO_ESCALATE_BY_DATE, paramNames, paramValues );
		
		return l;
	}
	
	public List<Message> getMessagesForEscalation() {

		List<Message> l = getHibernateTemplate().findByNamedQuery(QRY_MESSAGES_TO_ESCALATE);
		return l;
	}
	
	public List<Message> getEscalatedMessages() {

		List<Message> l = getHibernateTemplate().findByNamedQuery(QRY_ESCALATED_MESSAGES);
		return l;
	}
	
	public List<Message> getEscalatedMessagesToNotify() {
		
		List<Message> l = getHibernateTemplate().findByNamedQuery(QRY_ESCALATED_MESSAGES_TO_NOTIFY);
		return l;
	}
	
	/**
	 * @return list of messages that are not complete by threadId.
	 */
	public List<Message> getMessagesByThread(Long threadId){
		
		String[] paramNames = new String[] { "threadId" }; 
		Object[] paramValues = new Object[] { threadId }; 
		
		List<Message> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_MESSAGES_BY_THREAD, paramNames, paramValues );
		
		return l;
	}	
		

	/**
	 * @return list of previous messages that are not complete by messageId,threadId.
	 */
	public List<Message> getPreviousMessagesInThread(Long messageId, Long threadId){
		
		String[] paramNames = new String[] { "messageId", "threadId" }; 
		Object[] paramValues = new Object[] { messageId, threadId }; 
		
		List<Message> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_PREVIOUS_MESSAGES_BY_IDS, paramNames, paramValues );
		
		return l;
	}

    /**
     * @return list of messages that are not complete by threadId.
     */
    @SuppressWarnings("unchecked")
	public List<Message> getMessagesByThreadIds(Set threadIds){
                    
                    String[] paramNames = new String[] { "threadIds" }; 
                    Object[] paramValues = new Object[] { threadIds }; 
                    
                    List<Message> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
                                                    QRY_MESSAGES_BY_THREADIDS, paramNames, paramValues );
                    
                    return l;
    }              
	
    public List<Object[]> getFacilityAdminToNotify(Date dateAfterEscalatedXDays){
    	String[] paramNames = new String[] { "dateAfterEscalatedXDays" }; 
		Object[] paramValues = new Object[] { dateAfterEscalatedXDays }; 
		
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_FACILITYADMIN_TO_NOTIFIY, paramNames, paramValues );
		
		return l;
    	
    	
    }
    
 
    
	/**
	*  @return list of distribution group messages by parameters
	*  @param senderId, recipientId,checksum.
	*/
	public List<Object[]> getDistributionGroupMessagesByIds(Long senderId,Long recipientId,String checksum){
		String[] paramNames = new String[] { "senderId", "recipientId", "checksum" }; 
		Object[] paramValues = new Object[] { senderId,recipientId,checksum }; 
		
		List<Object[]> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_DISTRIBUTION_GROUP_MESSAGES_BY_IDS, paramNames, paramValues );
		
		return l;
	}
	
	public Boolean recallDistGroupMessages(Long messageId){
    	try{
    		Message message = findById(messageId);
    		if(message!=null){
    			String checkSum = message.getChecksum().trim();
        		Long senderId = message.getSenderId();
        		Long recipientId = message.getRecipientId();
        		if(log.isInfoEnabled()){
        			log.info("###9004##Dist.Recall MessageId:"+messageId+"^checkSum:"+checkSum+"^RecipientId:"+recipientId);	
        		}
        		
    		Object[] paramValues = new Object[] {messageId,checkSum,senderId,recipientId}; 
    		Query q = getSession().getNamedQuery(QRY_RECALL_DIST_MESSAGES);
    		String sql = q.getQueryString();
    		int updatedRecallMessageCount =getHibernateTemplate().bulkUpdate(sql,paramValues);
    		if(log.isInfoEnabled()){
    			log.info("###9004##Dist.Recall Messages Updated Count:"+updatedRecallMessageCount);
    		}
    		return 	Boolean.TRUE;
		}
	}catch(Exception e2){
		if(log.isErrorEnabled()){
			log.error("###9004-E2 Error while updating distribution group recall messages"+e2);
		}
		return Boolean.FALSE;
	  }
		return Boolean.FALSE;
   }
	
	public Boolean resetCPRSNotesStatusByThread(Long threadId){
		try{
			Object[] paramValues = new Object[] {threadId};
			Query q = getSession().getNamedQuery(QRY_RESET_CPRSNOTES_STATUS_BY_THREAD);
			String sql = q.getQueryString();
			getHibernateTemplate().bulkUpdate(sql,paramValues);
			return Boolean.TRUE;
		}catch(Exception e3){
			if(log.isErrorEnabled()){
				log.error("####An Error Occured while resetting CPRSNotes Status by Thread "+e3);
			}
			return Boolean.FALSE;
		}
	}	
}

