package gov.va.med.mhv.sm.dao.hibernate;

import java.util.Date;
import java.util.List;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.HolidayDao;
import gov.va.med.mhv.sm.model.Holiday;

public class HolidayDaoImpl extends BaseEntityDaoHibernate<Holiday, Long> 
	implements HolidayDao {

	
	@SuppressWarnings("unchecked")
	public boolean isDateHoliday(Date d){
		
		String[] paramNames = new String[] { "date" }; 
		Object[] paramValues = new Object[] { d }; 
		
		List<Holiday> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_HOLIDAY_BY_DATE, paramNames, paramValues );
		
		if(l.size() > 0)
			return true;
		else
			return false;
	}
		
	@SuppressWarnings("unchecked")
	public List<Holiday> getHolidaysInRange(Date start, Date end){
		
		String[] paramNames = new String[] { "start", "end" }; 
		Object[] paramValues = new Object[] { start, end }; 
		
		List<Holiday> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_HOLIDAYS_IN_RANGE, paramNames, paramValues );
		return l;	
	}
}

