package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import org.hibernate.LockMode;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.FolderDao;
import gov.va.med.mhv.sm.model.Folder;

public class FolderDaoImpl extends BaseEntityDaoHibernate<Folder, Long> 
	implements FolderDao {

	@SuppressWarnings("unchecked")
	public List<Folder> getFoldersForUser(Long ownerId){
		String[] paramNames = new String[] { "id" }; 
		Object[] paramValues = new Object[] { ownerId}; 
		
		return getHibernateTemplate().findByNamedQueryAndNamedParam(
				FolderDao.QRY_GET_FOLDERS_FOR_USER, paramNames, paramValues );
	}
	
	public void fleshFolder(Folder f){
		
		if(f.isSystemFolder()) return;
		
		getSession().lock(f,LockMode.NONE);
		getHibernateTemplate().initialize(f.getOwner());
	}
	
	
}

