package gov.va.med.mhv.sm.dao.hibernate;

import java.util.List;

import org.springframework.dao.DataIntegrityViolationException;

import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.FacilityDao;
import gov.va.med.mhv.sm.model.Facility;

public class FacilityDaoImpl extends BaseEntityDaoHibernate<Facility, Long> 
	implements FacilityDao {

	@SuppressWarnings("unchecked")
	public Facility getFacilityByStationNumber(String stationNumber){
		
		String[] paramNames = new String[] { "stationNumber" }; 
		Object[] paramValues = new Object[] { stationNumber }; 
		
		List<Facility> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_FACILITY_BY_STATIONNUMBER, paramNames, paramValues );
		
		if(l.size() > 1){
			/* There is a real problem here.  
			 * The database constraints should prevent this.
			 */
			throw new DataIntegrityViolationException("Duplicate facilities found with given constraints.");
		}
		
		if(l.size() > 0){
			return l.get(0);
		}else{
			return null;
		}
	}
	
	@SuppressWarnings("unchecked")
	public Facility getFacilityByName(String facilityName){
		
		String[] paramNames = new String[] { "facilityName" }; 
		Object[] paramValues = new Object[] { facilityName }; 
		
		List<Facility> l = getHibernateTemplate().findByNamedQueryAndNamedParam(
				QRY_FACILITY_BY_NAME, paramNames, paramValues );
		
		if(l.size() > 1){
			/* There is a real problem here.  
			 * The database constraints should prevent this.
			 */
			throw new DataIntegrityViolationException("Duplicate facilities found with given constraints.");
		}
		
		if(l.size() > 0){
			return l.get(0);
		}else{
			return null;
		}
		
	}
	
	public List<Facility> getFacilityByParent(String parentName){
		Facility parent = getFacilityByName(parentName);
		return (parent != null) ? getFacilityByParent(parent) : null;
	}
	
	
	@SuppressWarnings("unchecked")
	public List<Facility> getFacilityByParent(Facility parent){
		Precondition.assertNotNull("parent", parent);
		String[] paramNames = new String[] { "parentId" }; 
		Object[] paramValues = new Object[] { parent.getId() }; 
		return getHibernateTemplate().findByNamedQueryAndNamedParam(
			QRY_FACILITY_BY_PARENT, paramNames, paramValues );
	}

	public List<Facility> getFacilityByVisn(String visnName){
		
		// get the VISN object
		Facility visn = getFacilityByName(visnName);
		if(visn == null) return null;
		
		return getFacilityByVisn(visn);
	}
	
	
	@SuppressWarnings("unchecked")
	public List<Facility> getFacilityByVisn(Facility visn){
		Precondition.assertNotNull("visn", visn);
		String[] paramNames = new String[] { "visnId" }; 
		Object[] paramValues = new Object[] { visn.getId() }; 
		
		return getHibernateTemplate().findByNamedQueryAndNamedParam(
			QRY_FACILITY_BY_VISN, paramNames, paramValues );
	}
	
	@SuppressWarnings("unchecked")
	public List<Facility> getVisns(){
		
		List<Facility> l = getHibernateTemplate().findByNamedQuery(QRY_VISNS);
		return l;
	}

	@SuppressWarnings("unchecked")
	public List<Facility> getAllFacilities() {
		List<Facility> l = getHibernateTemplate().findByNamedQuery(QRY_FACILITIES);
		return l;
	}
	
	/**
	 * FACILITIES table is read only
	 */
	public Facility save(Facility f){
		/* no op */
		return null;
	}
//	public void update(Facility f){
//		/* no op */
//	}
	public Facility delete(Long id){
		/* no op */
		return null;
	}
	public void deleteAll(){
		/* no op */
	}

}

