package gov.va.med.mhv.sm.dao.hibernate;

import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.DistributionGroupDao;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.DistributionGroup;

import java.util.List;

import org.hibernate.LockMode;

public class DistributionGroupDaoImpl extends BaseEntityDaoHibernate<DistributionGroup, Long> 
	implements DistributionGroupDao{
	public static final String QRY_DIST_GROUPS = "QryDistributionGroupsForUser";
	public static final String QRY_GET_ALL_GROUPS = "QryGetAllDistributionGroups";
	
	public void getMembersForDistributionGroup(DistributionGroup d){
		try{
			getSession().lock(d,LockMode.NONE);
			getHibernateTemplate().initialize(d.getMembers());
		}catch(Exception e){
			/* no op */
		}
	}
	
	public void getOwnerForDistributionGroup(DistributionGroup d){
		getSession().lock(d, LockMode.NONE);
		getHibernateTemplate().initialize(d.getOwner());
	}

	@SuppressWarnings("unchecked")
	public List<DistributionGroup> getDistributionGroups(Clinician c) {
		String[] paramNames = new String[] { "userId" }; 
			Object[] paramValues = new Object[] { c.getId()}; 
			List<DistributionGroup> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
					QRY_DIST_GROUPS, paramNames, paramValues );
			return l;
	}
	
	@SuppressWarnings("unchecked")
	public List<Object[]> getAllDistributionGroupsByUserOrShared(Clinician c) {
		String[] paramNames = new String[] { "userId","stationNumber" }; 
			Object[] paramValues = new Object[] { c.getId(),c.getStationNo()}; 
			List<Object[]> l =  getHibernateTemplate().findByNamedQueryAndNamedParam(
					QRY_GET_ALL_GROUPS, paramNames, paramValues );
			return l;
	}
	
}