package gov.va.med.mhv.sm.dao.hibernate;

import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.persistence.dao.hibernate.BaseEntityDaoHibernate;
import gov.va.med.mhv.sm.dao.CredentialsDao;
import gov.va.med.mhv.sm.model.Credentials;
import gov.va.med.mhv.sm.model.User;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

public class CredentialsDaoImpl 
	extends BaseEntityDaoHibernate<Credentials, Long> implements CredentialsDao 
{
	

	@SuppressWarnings("unchecked")
	public Credentials findForUser(Long userId) {
		Precondition.assertNotNull("userId", userId);
		String[] paramNames = new String[] { "userId" }; 
		Object[] paramValues = new Object[] { userId }; 
		
		return getSingleValue(getHibernateTemplate().
			findByNamedQueryAndNamedParam(FIND_CREDENTIALS_FOR_USER, 
			paramNames, paramValues)); // "unchecked"
	}

	public Credentials findForUser(User user) {
		Precondition.assertNotNull("user", user);
		Long id = user.getId();
		Precondition.assertNotNull("user.id", id);
		return findForUser(id);
	}

	@SuppressWarnings("unchecked")
	public Credentials findNonExpiredForUser(Long userId) {
		Precondition.assertNotNull("userId", userId);
		String[] paramNames = new String[] { "userId" }; 
		Object[] paramValues = new Object[] { userId }; 
		
		return getSingleValue(getHibernateTemplate().
			findByNamedQueryAndNamedParam(FIND_NON_EXPIRED_CREDENTIALS_FOR_USER, 
			paramNames, paramValues)); // "unchecked"
	}

	public Credentials findNonExpiredForUser(User user) {
		Precondition.assertNotNull("user", user);
		Long id = user.getId();
		Precondition.assertNotNull("user.id", id);
		return findNonExpiredForUser(id);
	}
	
	private Credentials getSingleValue(List<Credentials> credentials) {
		return (CollectionUtils.size(credentials) > 0) ? credentials.get(0) 
				: null;
	}

}

