package gov.va.med.mhv.sm.dao.exception;


import gov.va.med.mhv.foundation.dao.exceptions.GenericDataAccessException;

/**
 * Data access-agnostic exception indicating that an inconsistency was found
 * by the data access strategy responsible for throwing it.
 * 
 */
public class DataIntegrityException extends GenericDataAccessException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -91755597247149500L;

	/**
	 * Instantiate a generic data access exception with the specified message
	 * and throwable exception
	 * @param msg - message to use
	 * @param ex - the root cause
	 */
	public DataIntegrityException(String msg, Throwable ex) {
		super(msg, ex);
	}
	
	/**
	 * Instantiate a generic data access excpetion using a just a string
	 * as the message
	 * @param msg - message to create the 
	 */
	public DataIntegrityException(String msg) {
		super(msg);
	}
	
}