package gov.va.med.mhv.sm.dao;

import java.util.List;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.enumeration.RelationTypeEnum;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.TriageRelation;

public interface TriageRelationDao extends BaseEntityDao<TriageRelation, Long> {

	public static final String QRY_PATIENT_TRIAGE_GROUP_RELATIONS = "QryPatientTriageGroupRelations";
	public static final String QRY_PATIENT_TRIAGE_GROUP_RELATIONS_ALL = "QryPatientTriageGroupRelationsAll";
	public static final String QRY_RELATIONS_FOR_IEN = "QryRelationsForIen";
	public static final String QRY_UNIQUE_RELATIONS = "QryUniqueRelations";
	public static final String QRY_PATIENT_TRIAGE_GROUP_RELATIONS_BY_STATION = "QryPatientTriageGroupRelationsByStation";
	public static final String QRY_PATIENT_TRIAGE_GROUP_RELATIONS_BY_STATION_ALL = "QryPatientTriageGroupRelationsByStationAll";
	public static final String QRY_TRIAGE_RELATIONIDs_BY_TRIAGEGROUP = "QryGetTriageRelationIdByTriageGroup";
	public static final String QRY_TRIAGE_RELATIONs_For_TRIAGEGROUP = "QryRelationsForTriageGroup";
	

	public List<TriageRelation> getTriageGroupRelationsForPatient(Patient patient);
	public List<TriageRelation> getTriageGroupRelationsForPatientAll(Patient patient);

	public List<TriageRelation> find(String ien, String stationNo, RelationTypeEnum relationType);

	public List<TriageRelation> getTriageGroupRelationsForPatientStation(
			Patient patient, String stationNo);

	public List<TriageRelation> getTriageGroupRelationsForPatientStationAll(
			Patient patient, String stationNo);

	public List getRelationId(Long triageGroupId,String patientId) ;

	public void fleshTriageGroup(TriageRelation tr);
	
	public List<TriageRelation> getTriageRelationsForTriageGroup(Long triageGroupId);

}
