package gov.va.med.mhv.sm.dao;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.SMClinicsCPRSTitle;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.TriageGroup;

public interface TriageGroupDao extends BaseEntityDao<TriageGroup, Long> {

	public static final String QRY_TRIAGE_GROUP_PATIENTS = "QryTriageGroupPatients";
	public static final String QRY_TRIAGE_GROUPS_FOR_PATIENTS = "QryTriageGroupsForPatient";
	public static final String QRY_TRIAGE_GROUPS_FOR_CLINICIAN = "QryTriageGroupsForClinician";
	public static final String QRY_TRIAGE_GROUPS_FOR_STATION = "QryTriageGroupsForStation";
	public static final String QRY_TRIAGE_GROUPS_ALL_ACTIVE = "QryTriageGroupsAllActive";
	public static final String QRY_TRIAGE_GROUPS_BY_NAME = "QryTriageGroupsByName";
	public static final String QRY_ACTIVE_TRIAGE_GROUPS_BY_NAME = "QryActiveTriageGroupsByName";
	public static final String QRY_OPEN_MSGS_FOR_TRIAGE_GROUP = "QryOpenMsgsForTriageGroup";
	public static final String QRY_MSGS_TO_NOTIFY_FOR_TRIAGE_GROUP = "QryMsgsToNotifyForTriageGroup";
	public static final String QRY_ASSIGNED_MSGS_FOR_TRIAGRE_GROUP = "QryAssignedMsgsForTriageGroup";
	public static final String QRY_INACTIVE_TRIAGE_GROUPS_FOR_STATION = "QryInActiveTriageGroupsForStation";
	public static final String QRY_TRIAGE_GROUPS_FOR_PATIENTS_BY_STATION = "QryTriageGroupsForPatientByStation";
	public static final String QRY_GET_ACTVE_SMCLINICS_BYTRIAGEGROUP ="QryGetActiveSMClinicByTriageGroup";
	public static final String QRY_GET_ALL_ACTIVE_CPRS_TITLES="QryGetAllActiveCPRSTitles";
	public static final String QRY_GET_USERS_AND_SURROGATES_FOR_TRIAGEGROUP="QryUsersAndSurrogatesForTriageGroup";
	public static final String QRY_GET_VISN_AND_FACILITY_BY_TRIAGEGROUP="QryGetVisnAndFacilityByTriageGroup";
	public static final String QRY_GET_ASSOCIATED_SM_CLINIS_BY_CLINICIAN_AND_STATIONNUMBER="QryGetAssociatedSMClinicsByClinicianAndStationNumber";
	public static final String QRY_GET_FACILITY_ADMINS_EMAIL_ADDRESS_BY_STATION="QryGetFacilityAdminsEmailByStation";
	
	
	
	/**
	 * WARNING:  Any changes will be lost.  
	 *   Save changes first if necessary.
	 * @param t
	 */
	public void getPatientsForTriageGroup(TriageGroup t);
	
	/**
	 * WARNING:  Any changes will be lost.  
	 *   Save changes first if necessary.
	 * @param t
	 */
	public void getCliniciansForTriageGroup(TriageGroup t);
		
	
	public TriageGroup getSMClinicsForTriageGroup(Long triageGroupId);
	
	/**
	 * Return a list of TriageGroups that a patient has
	 * a relationship to.  Thus allowing them to send messages
	 * to that group. 
	 * 
	 * @param p Patient
	 * @return  list of TriageGroups
	 */
	public Collection<TriageGroup> getTriageGroupsForPatient(Patient p);
	
	
	

	/**
	 * Return a list of TriageGroups that a patient has
	 * a relationship to.  Thus allowing them to send messages
	 * to that group. 
	 * 
	 * @param p Patient
	 * @return  list of TriageGroups
	 */
	public Collection<TriageGroup> getTriageGroupsForPatientByStation(Patient p,String stationNumber);
		
	/**
	 * Return a list of TriageGroups that the clinician is a
	 * member of.
	 * 
	 * @param c Clinician
	 * @return
	 */
	public List<TriageGroup> getTriageGroupsForClinician(Clinician c);
	
	
	/**
	 * Return a list of TriageGroups for a particular VistA system
	 * 
	 * @param station VistA station or division number
	 * @return
	 */
	public List<TriageGroup> getTriageGroupsForStation(String station);
	
	
	/**
	 * WARNING:  has potential for being very large dataset
	 * 
	 * @return
	 */
	public List<TriageGroup> getTriageGroupsAllActive();
	
	
	/** 
	 * Search for a triage group by name
	 * @return
	 */
	public TriageGroup findTriageGroupByName(String name);
	
	/** 
	 * Search for a Active triage group by name
	 * @return
	 */
	public TriageGroup findActiveTriageGroupByName(String name);
	
	public List<Message> getOpenMsgsForTriageGroup(TriageGroup tg);
	
	
	/**
	 * Get all messages that been escalated but not notified for the given
	 * triage group
	 *
	 * @param tg
	 * @return list of messages
	 */
	public List<Message> getMsgsToNotifyForTriageGroup(TriageGroup tg);
	

	/**
	 * Get all messages that been assigned to the userList.
	 * 
	 * @param tg,userList
	 * @return list of messages
	 */
	public List<Message> getAssignedMsgsForTriageGroup(TriageGroup tg,List userList);

	
	/**
	 * fetch the triage relations for a give triage group
	 * @param tg
	 */
	public void fleshRelations(TriageGroup tg);
	
	/**
	 * Return a list of In ActiveTriageGroups for a particular VistA system
	 * 
	 * @param station VistA station or division number
	 * @return
	 */
	public List<TriageGroup> getInActiveTriageGroupsForStation(String station);
	
	/**
	 * Return a list of All Active CPRS Title 
	 * 	  
	 * @return of CPRS titles
	 */
	public TreeSet<String> getAllActiveSMClinicsCPRSTitles();
		
	
	public SMClinicsTriageMap getActiveSMClinicByTriageGroup(Long triageGroupId);
	
	public List<Object[]> getUsersAndSurrogatesForTriageGroup(Long triageGroupId);
	
	public List<Object[]> getVisnAndFaciltiyByTriageGroup(Long triageGroupId);
	
	public List<Object[]> getAssociatedSMClinicsByClinicianAndStation(Long stationNumber, Long userId);
	
	public List<Object[]> getFacilityAdminsEmailsByStation(String stationNumber);
	
	public TriageGroup getTriageGroupAndRelations(Long triageGroupId);
}
