package gov.va.med.mhv.sm.dao;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.model.TiuNoteRecord;

import java.util.List;


public interface TiuNoteRecordDao extends BaseEntityDao<TiuNoteRecord, Long> {

	public static final String QRY_TIU_RECORD_CONVERSATION = "QryTiuRecordConversation";
	public static final String QRY_TIU_RECORD_THREADS = "QryTiuThreads";
	public static final String QRY_TIU_RECORD_THREAD = "QryTiuThread";
	public static final String QRY_GET_PROGRESSNOTES_STATUS_BYTHREAD_ID = "QryGetProgressNotesStatusByThreadId";
	public static final String QRY_GET_TIU_RECORD_BYTHREADANDMESSAGE_ID = "QryTiuNoteRecordByThreadAndMessageId";
	public static final String QRY_GET_FAILED_CPRS_NOTES_BY_STATIONNUMBER = "QryFailedCprsProgressNotesByStation";
	public static final String QRY_CHANGE_PREVIOUS_SAVED_NOTES_BY_THREAD_AND_MESSAGE_ID = "QryResetPreviousSavedNotesByThreadAndMessageId";
	
	
	
	public List<TiuNoteRecord> getRecords(Long threadId, String vistaDiv);
	
	public TiuNoteRecord getRecord(Long threadId, String vistaDiv);
	
	
	public TiuNoteRecord getRecord(String conversationId);
	
	public List<Object[]> getProgressNotesStatusByThreadId(Long threadId);
	
	public TiuNoteRecord getTiuNoteRecordByThreadAndMessageId(Long threadId,Long messageId);
	
	public List<Object[]> getFailedCPRSProgressNotesByStation(String stationNumber);
	
	public Boolean changePreviousTiuNoteRecordStatusByThreadAndMessageId(Long threadId,Long messageId);
	
}
