package gov.va.med.mhv.sm.dao;

import java.util.List;
import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Surrogate;
public interface SurrogateDao extends BaseEntityDao<Surrogate,Long> {

	public static final String QRY_GET_SURROGATE_FOR_USER = "QryGetSurrogateForUser";
	public static final String QRY_GET_CURRENT_SURROGATE_FOR_USER = "QryGetCurrentSurrogateForUser";
	public static final String QRY_DELETE_SURROAGE_BY_USER = "QryDeleteSurrogateByUser";
	public static final String QRY_CLINICIANS_WITH_TG_SURROGATE ="QryClinicansWithTgSurrogate"; 
	
	/*
	 *  Get list of surrogate by user
	 *  @param userId
	 *  @return List of Surrogate 
	 */
	public List<Surrogate> getSurrogatesFor(Clinician c);
	
	/*
	 *  Get Current Surrogate by user
	 *  @param userId
	 *  @return Surrogate
	 */
	public Surrogate getCurrentSurrogateFor(Clinician c);
	
	
	/*
	 *  Delete All Surrogate By User
	 *  @param userId
	 *  @return Boolean
	 */
	@SuppressWarnings("unchecked")
	public int clearSurrogatesFor(Clinician c);
	
	
	public List<Surrogate> findClinicansWithTriageGroupSurrogate(Long tgId);
	
	
}
