package gov.va.med.mhv.sm.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.ReAssignMessageActionEnum;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.ReAssignMessageHistory;

public interface ReAssignMessageDao extends BaseEntityDao<ReAssignMessageHistory, Long> {
	
	public static final String QRY_FIND_RECEIVED_HISTORY_ACTION_BY_MESSAGE = "QryFindMessageReceivedActionByMessage";
	
	public static final String QRY_GET_HISTORY_BY_MESSAGE_AND_ACTION = "QryGetHistoryByMessageAndAction";
	
	public static final String QRY_GET_REASSIGN_HISTORY_BY_MESSAGE ="QryGetReAssignMessageHistoryByMessage";
	
	public static final String QRY_GET_AUTO_ASSOCIATED_TG_HISTORY_BY_MESSAGE ="QryGetAutoAssociatedTGMessageHistoryByMessage";
	
	
	
	public Boolean findMessageReceivedHistoryByMessage(Long secureMessageId);		
	
	public ReAssignMessageHistory getMsgHistoryByMsgAndAction(Long secureMessageId, ReAssignMessageActionEnum action);
	
	public Collection<ReAssignMessageHistory> getReAssignMessageHistoryByMessage(Long secureMessageId);
	
	public ReAssignMessageHistory getAutoAssociatedTGHistoryByMessage(Long secureMessageId);
	
}

	
