package gov.va.med.mhv.sm.dao;

import java.util.Collection;
import java.util.List;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;

public interface PatientBlockedTriageGroupDao extends BaseEntityDao<PatientBlockedTriageGroup, Long> {

		public static final String QRY_DELETE_PATIENT_BLOCKED_TG_BY_PATIENTIDANDSTATION= "QryDeletePatientBlockedTGByPatientIdAndStation";
		public static final String QRY_GET_PATIENT_BLOCKED_TGS_BY_PATIENTIDANDSTATION= "QryGetBlockedTGsByPatientIdAndStation";
		public static final String QRY_GET_BLOCKED_PATIENTS_DETAILS_BY_TRIAGEGROUP_ID= "QryGetBlockedPatientsDetailsByTriageGroupId";
		public static final String QRY_GET_BLOCKED_PATIENTTRIAGEGROUPS_BY_PATIENT_ID= "QryGetPatientBlockedTriageGroupsByPatientId";
		public static final String QRY_GET_BLOCKED_PATIENTTRIAGEGROUP_BY_TG_ID_AND_PATIENT_ID= "QryGetPatientBlockedTriageGroupByTgIdAndPatientId";
		public static final String QRY_GET_BLOCKED_PATIENTS_BY_TRIAGEGROUP_ID= "QryGetBlockedPatientsByTriageGroupId";
		public static final String QRY_GET_BLOCKED_PATIENTS_LIST_BY_PATIENTID_AND_STATION= "QryGetBlockedPatientsListByPatientIdAndStation";
		
		public void clearPatientBlockedTriageGroupByPatientIdAndStation(Long patientId, Long stationNumber);
		public void clearPatientBlockedTriageGroupByPatientId(Long patientId);
		public List<Object[]>  getPatientBlockedTriageGroupsByPatientIdAndStation(Long patientId,Long stationNumber);
		public List<Object[]>  getBlockedPatientsDetailsByTriageGroupId(Long triageGroupId);
		public Collection<PatientBlockedTriageGroup> getPatientBlockedTriageGroupsByPatientId(Long patientId);
		public PatientBlockedTriageGroup getPatientBlockedTriageGroupByTgIdAndPatientId(Long triageGroupId,Long patientId);
		public Collection<PatientBlockedTriageGroup> getBlockedPatientsByTriageGroupId(Long triageGroupId);
		public Collection<PatientBlockedTriageGroup> getBlockedPatientsListByPatientIdAndStation(Long patientId, Long stationNumber);
		
		
		

}

	
