package gov.va.med.mhv.sm.dao;

import java.util.Collection;
import java.util.List;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;

public interface PatientBlockedFacilityDao extends BaseEntityDao<PatientBlockedFacility, Long> {


		public static final String QRY_DELETE_PATIENT_BLOCKED_FACILITY_BY_PATIENTIDANDSTATION= "QryDeletePatientBlockedFacilityByPatientIdAndStation";
		public static final String QRY_GET_BLOCKED_FACILITY_PATIENTS_DETAILS_BY_PATIENT_ID= "QryGetBlockedFacilityPatientsDetailsByPatientId";
		public static final String QRY_GET_BLOCKED_FACILITY_PATIENTS_DETAILS_BY_STATION= "QryGetBlockedFacilityPatientsDetailsByStation";
		public static final String QRY_GET_BLOCKED_FACILITY_PATIENTS_DETAILS_BY_PATIENTID_AND_STATION="QryGetBlockedFacilityPatientsDetailsByPatientIdAndStation";

		public static final String QRY_GET_BLOCKED_FACILITY_PATIENTS_BY_PATIENTID_AND_STATION= "QryGetBlockedFacilityPatientsByPatientIdAndStation";
		public static final String QRY_GET_BLOCKED_FACILITY_PATIENTS_BY_STATION= "QryGetBlockedFacilityPatientsByStation";
		public static final String QRY_GET_BLOCKED_FACILITIES_BY_PATIENT_ID= "QryGetBlockedFacilitiesByPatientId";

		public void clearPatientBlockedFacilityByPatientIdAndStation(Long patientId, Long stationNumber);
		public List<Object[]>  getBlockedFacilityPatientsDetailsByStation(Long stationNumber);
		public List<Object[]>  getBlockedFacilityPatientsDetailsByPatientId(Long patientId);
		public List<Object[]>  getPatientBlockedFacilityByPatientIdAndStation(Long patientId,Long stationNumber);

		public Collection<PatientBlockedFacility> getBlockedFacilityPatientsByPatientIdAndStation(Long patientId,Long stationNumber);
		public Collection<PatientBlockedFacility> getBlockedFacilityPatientsByStation(Long stationNumber);
		public Collection<PatientBlockedFacility> getBlockedFacilitiesByPatientId(Long patientId);
}
