package gov.va.med.mhv.sm.dao;

import java.util.Date;
import java.util.List;
import java.util.Set;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Message;

public interface MessageDao extends BaseEntityDao<Message, Long> {
	
	public static final String QRY_ESCALATE_MESSAGES = "QryEscalateMessages";
	public static final String QRY_MESSAGES_TO_ESCALATE = "QryGetMessagesForEscalation";
	public static final String QRY_ESCALATED_MESSAGES = "QryGetEscalatedMessages";
	public static final String QRY_ESCALATED_MESSAGES_TO_NOTIFY = "QryGetEscalatedMessagesToNotify";
	public static final String QRY_MESSAGES_BY_THREAD = "QryGetMessagesByThread";
	public static final String QRY_PREVIOUS_MESSAGES_BY_IDS = "QryGetPreviousMessagesByIds";
	public static final String QRY_MESSAGES_BY_THREADIDS = "QryGetNonCompletedMessagesByThreadIds";
	public static final String QRY_FACILITYADMIN_TO_NOTIFIY = "QryGetFacilityAdminToNotify";
	public static final String QRY_GET_MESSAGES_TO_ESCALATE_BY_DATE = "QryGetMessagesToEscalateByDate";
	public static final String QRY_RECALL_DIST_MESSAGES = "QryRecallDistributionMessages";
	public static final String QRY_DISTRIBUTION_GROUP_MESSAGES_BY_IDS = "QryDistributionGroupMessagesByIds";
	public static final String QRY_RESET_CPRSNOTES_STATUS_BY_THREAD = "QryResetCPRSNotesStatusByThread";
	
	
	
	/**
	 * Take a message and fill in the Thread
	 * and  from the database. 
	 * 
	 * @param m Message to fetch the Thread for.
	 * @return
	 */
	public void fillThread(Message m);
	
	
	/**
	 * Return a message with the thread,
	 * thread.messages and thread.annotations filled out.
	 * 
	 * @param  messageId  the id of the message to fetch
	 * @return            a Message completely fleshed out
	 */
	public Message getMessageComplete(Long messageId);
	
	
	/**
	 * 
	 * @param escalationDate  Message sent before this date
	 *                        will be escalated.
	 */
	public int escalateMessages(Date escalationDate);
	

	/**
	 *
	 * @return list of messages that are not complete and not escalated
	 *
	 */
	public List<Message> getMessagesForEscalation();

	/**
	 *
	 * @return list of messages that are escalated but not complete
	 *
	 */
	public List<Message> getEscalatedMessages();
	
	/**
	 * @return list of messages that have been escalated and need to have notifications sent
	 */
	public List<Message> getEscalatedMessagesToNotify();
	
	/**
	 * @return list of messages that are not complete by threadId.
	 */
	public List<Message> getMessagesByThread(Long threadId);
	
	/**
	 * @return list of previous messages that are not complete by messageId, threadId.
	 */
	public List<Message> getPreviousMessagesInThread(Long messageId,Long threadId);
	
    /**
     * @return list of messages that are not complete by threadId.
     */
    public List<Message> getMessagesByThreadIds(Set threadIds);
    
 
	/**
	 *  @param dateAfterEscalatedXDays  Message still escalated after X days.
	 */
	public List<Object[]> getFacilityAdminToNotify(Date dateAfterEscalatedXDays);
	
	public List<Message> getMessagesToEscalateByDate(Date escalateDate);
	

	 
	
	/**
	*  @return list of distribution group messages by parameters
	*  @param senderId, recipientId,checksum.
	*/
	public List<Object[]> getDistributionGroupMessagesByIds(Long senderId,Long recipientId,String checksum);
	
	/**
	 * 
	 * @param recall  distribution group Messages. 
	 */
	 public Boolean recallDistGroupMessages(Long messageId);
	 
	 public Boolean resetCPRSNotesStatusByThread(Long threadId);
	 
	
}
