package gov.va.med.mhv.sm.dao;

import java.util.List;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.model.Facility;


public interface FacilityDao extends BaseEntityDao<Facility, Long> {

	public static final String QRY_FACILITY_BY_STATIONNUMBER = "QryGetFacilityByStationNumber";
	public static final String QRY_FACILITY_BY_NAME = "QryGetFacilityByName";
	public static final String QRY_FACILITY_BY_PARENT = "QryGetFacilityByParent";
	public static final String QRY_FACILITY_BY_VISN = "QryGetFacilityByVisn";
	public static final String QRY_VISNS = "QryGetVisns";
	public static final String QRY_FACILITIES = "QryGetFacilities";
		
	
	public Facility getFacilityByStationNumber(String stationNumber);
	
	public Facility getFacilityByName(String facilityName);
	
	public List<Facility> getFacilityByVisn(String visnName);
	public List<Facility> getFacilityByVisn(Facility visn);
	public List<Facility> getFacilityByParent(String parentName);
	public List<Facility> getFacilityByParent(Facility parent);
	
	public List<Facility> getVisns();
	
	public List<Facility> getAllFacilities();
}
