package gov.va.med.mhv.sm.dao;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.model.Credentials;
import gov.va.med.mhv.sm.model.User;

public interface CredentialsDao extends BaseEntityDao<Credentials, Long> {
	
	public static final String FIND_CREDENTIALS_FOR_USER = 
		"Credentials_FindForUser";

	public static final String FIND_NON_EXPIRED_CREDENTIALS_FOR_USER = 
		"Credentials_FindNonExpiredForUser";

	/**
	 * Return the credentials of athe user with the given userId.
	 * @param userId Id of user to get credentials for.
	 * @return The crdentials, if found; null otherwise.
	 */
	public Credentials findForUser(Long userId);
	
	/**
	 * Return the credentials of the given user.
	 * @param user User to get credentials for.
	 * @return The credentials, if found; null otherwise.
	 */
	public Credentials findForUser(User user);

	/**
	 * Return the non-expired credentials of athe user with the given userId.
	 * @param userId Id of user to get credentials for.
	 * @return The crdentials, if found; null otherwise.
	 */
	public Credentials findNonExpiredForUser(Long userId);
	
	/**
	 * Return the non-expired credentials of the given user.
	 * @param user User to get credentials for.
	 * @return The credentials, if found; null otherwise.
	 */
	public Credentials findNonExpiredForUser(User user);
}
