package gov.va.med.mhv.sm.dao;

import gov.va.med.mhv.foundation.dao.BaseEntityDao;
import gov.va.med.mhv.sm.dto.SearchFormDTO;
import gov.va.med.mhv.sm.enumeration.MessageFilterEnum;
import gov.va.med.mhv.sm.enumeration.MessagesOrderByEnum;
import gov.va.med.mhv.sm.enumeration.SortOrderEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.MessagesPage;
import gov.va.med.mhv.sm.model.priv.MessageCount;

import java.util.List;


public interface AddresseeDao extends BaseEntityDao<Addressee, Long> {

	public static final String QRY_MESSAGE_COUNTS = "QryMessageCounts";
	
	public static final String QRY_MESSAGE_COUNT_ALL = "QryMessageCountAll";
	public static final String QRY_MESSAGE_COUNT_UNASSIGNED = "QryMessageCountUnassigned";
	public static final String QRY_MESSAGE_COUNT_ASSIGNED_TO = "QryMessageCountAssignedTo";
	
	public static final String QRY_ESCALATED_COUNT = "QryEscalatedCount";
	public static final String QRY_REASSIGNED_COUNT = "QryReassignedCount";
	public static final String QRY_REMINDER_COUNT = "QryReminderCount";
	
	public static final String QRY_ADDRESSEE_BY_TYPE = "QryGetAddresseeByType";
	public static final String QRY_ADDRESSEE_FOR_USER_MESSAGE = "QryGetAddresseeForUserMessage";
	public static final String QRY_COUNT_MESSAGE_REMINDERTODAY = "QryCountMessageReminderToday";
	
	public static final String QRY_MESSAGE_CATEGORY_COUNTS = "QryInboxMessageCategoryCounts";
	public static final String QRY_MESSAGE_CATEGORY_COUNTS_UNASSIGNED = "QryInboxMessageCategoryCountsUnassigned";
	public static final String QRY_MESSAGE_CATEGORY_COUNTS_ASSIGNED_TO = "QryInboxMessageCategoryCountsAssignedTo";
	public static final String QRY_CPRSALERTS_COUNT = "QryCPRSAlertsCount";
	
	
	
	/**
	 * Return a folder list that contains not
	 * NOTE:  escalated counts are not include use getEscalatedCount
	 * @param ownerID
	 * @return
	 *   return a list of folders with associated message counts
	 */
	public List<MessageCount> getFolderCounts(Long ownerId);
	
	/**
	 * Return a folder list that contains count of category folders
	 * @param folder
	 * @return
	 *   return a list of sub-folders with associated message counts
	 */
	public List<MessageCount> getCategoryCounts(Folder folder);
	
	/**
	 * Return a folder list that contains count of category folders
	 * @param ownerID
	 * @return
	 *   return a list of sub-folders with associated message counts
	 */
	public List<MessageCount> getCategoryCounts(Long ownerId);
	
	/**
	 * Return the counts with Filter Applied
	 * NOTE:  escalated counts are not include use getEscalatedCount
	 * @param folder
	 * @return
	 *   return a count summary based on folder filter
	 */
	public MessageCount getFolderCounts(Folder f);
	
	/**
	 * Return the escalated counts
	 * NOTE:  Although this will return positive results for a 
	 * patient it should only be used for clinicians.
	 * 
	 * NOTE:  the last param "messageCount" should be the count of messages
	 * that exists in the folder.  We already have this information and
	 * passing it in lets us use a FORWARD_ONLY scroll which reduces fetch
	 * time 5 fold.
	 * 
	 * @param ownerId
	 * @return
	 */
	public MessageCount getEscalatedCount(Long ownerId);
	
	
	/**
	 * Return count
	 * NOTE:  Query returns count, If count > 0, address have reminder_date setup with today's date.  
	 * @param userId
	 * @return
	 */
	public int getMessageReminderToday(Long userId);
	
	
	/**
	 * Return a subset of messages for a particular user/folder
	 * The pages are 0 based. 
	 * 
	 * NOTE:  the last param "messageCount" should be the count of messages
	 * that exists in the folder.  We already have this information and
	 * passing it in lets us use a FORWARD_ONLY scroll which reduces fetch
	 * time 5 fold.
	 * 
	 * @param userId
	 * @param folderId
	 * @param pageNumber
	 * @param filter
	 * @param orderBy
	 * @param sortOrder
	 * @param messageCount
	 * @return
	 */
//	public MessagesPage getMessages(Long userId, Long folderId, int pageNumber, 
//			MessagesOrderByEnum orderBy, MessageFilterEnum filter, 
//			SortOrderEnum sortOrder, int messageCount);
		
	
	/**
	 * Return a subset of messages for a particular user/folder
	 * The pages are 0 based. 
	 * 
	 * NOTE:  the last param "messageCount" should be the count of messages
	 * that exists in the folder.  We already have this information and
	 * passing it in lets us use a FORWARD_ONLY scroll which reduces fetch
	 * time 5 fold.
	 * 
	 * @param userId
	 * @param folderId
	 * @param pageNumber
	 * @param filter
	 * @param orderBy
	 * @param sortOrder
	 * @param messageCount
	 * @param searchForm
	 * @param subfolder
	 * @return
	 */
	public MessagesPage getMessages(Long userId, Long folderId, int pageNumber, int pageSize,
			MessagesOrderByEnum orderBy, MessageFilterEnum filter, 
			SortOrderEnum sortOrder, int messageCount, SearchFormDTO searchForm, Long subFolderId);
	
	/**
	 * Return an Addressee for the given Message and User
	 * 
	 * @param userId     User id
	 * @param messageId  Message id 
	 * @return           Addressee 
	 */
	public Addressee getAddresseeForUser(Long userId, Long messageId);

	/**
	 * New for API.  Populate counts for reassigned view.
	 * @param id
	 * @return
	 */
	public MessageCount getReassignedCount(Long id);

	/**
	 * New for API.  Populate counts for reminder view.
	 * @param id
	 * @return
	 */
	public MessageCount getReminderCount(Long id);
	
	
	public MessageCount getCPRSAlertsCount(Long userId);
	
}
