package gov.va.med.mhv.sm.crypto;

import org.apache.commons.lang.StringUtils;

import gov.va.med.mhv.foundation.crypto.MHVCipher;
import gov.va.med.mhv.foundation.util.Precondition;

public class KeyGenerator {

	private static final String COMPONENT_SEPARATOR = "||";

	private final MHVCipher cipher;
	private final String salt;
	
	public KeyGenerator(MHVCipher cipher, String salt) {
		Precondition.assertNotNull("salt", salt);
		this.cipher = cipher;
		this.salt = salt + COMPONENT_SEPARATOR;
	}

	public String build(String[] components) {
		Precondition.assertNotNull("components", components);
		String key = salt + StringUtils.join(components, 
			COMPONENT_SEPARATOR);
		return (cipher != null) ? cipher.encrypt(key) : key;
	}

	public String[] extract(String key) {
		Precondition.assertNotBlank("key", key);
		key = (cipher != null) ? cipher.decrypt(key) : key;
		key = StringUtils.substringAfter(key, salt);
		return StringUtils.split(key, COMPONENT_SEPARATOR);
	}
	
}
