package gov.va.med.mhv.sm.ad;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.errors.IntrusionException;

public class ADQuery {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ADQuery.class);

	private String url;
	private String principal;
	private String credentials;
	private String searchBase;
	public String getSearchBase() {
		return searchBase;
	}

	public void setSearchBase(String searchBase) {
		this.searchBase = searchBase;
	}

	@SuppressWarnings("unchecked")
	private Hashtable env = null;

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getPrincipal() {
		return principal;
	}

	public void setPrincipal(String principal) {
		this.principal = principal;
	}

	public String getCredentials() {
		return credentials;
	}

	public void setCredentials(String credentials) {
		this.credentials = credentials;
	}

	@SuppressWarnings("unchecked")
	private Hashtable getEnv() {
		if (env == null) {
			env = new Hashtable(5);
			env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
			env.put(Context.SECURITY_AUTHENTICATION, "simple");
			env.put(Context.SECURITY_PRINCIPAL, getPrincipal());
			env.put(Context.SECURITY_CREDENTIALS, getCredentials());
			env.put(Context.PROVIDER_URL, getUrl());
		}
		return env;
	}

	@SuppressWarnings("unchecked")
	public List<ADQueryResult> queryUser(String userName) {
		List<ADQueryResult> list = null;
		LdapContext ldapContext = null;
		SearchControls sc = new SearchControls();
		sc.setReturningAttributes(new String[] { "sAMAccountName", "cn",
				"givenName", "sn", "title", "physicalDeliveryOfficeName",
				"department", "company", "telephoneNumber", "mail" }); // Specify
																		// the
		sc.setSearchScope(SearchControls.SUBTREE_SCOPE);
		try {
			ldapContext = new InitialLdapContext(getEnv(), null);
			String searchFilter = "(&(objectClass=user)(sAMAccountName=" + ESAPI.encoder().encodeForLDAP(userName) + "))";
			NamingEnumeration searchResults = ldapContext.search("DC=va,DC=gov", searchFilter, sc);
			list = new ArrayList<ADQueryResult>();
			while (searchResults.hasMoreElements()) {
				SearchResult searchResult = (SearchResult) searchResults.next();
				Attributes attributes = searchResult.getAttributes();
				if (attributes != null) {
					ADQueryResult r = new ADQueryResult();
					if (attributes.get("sAMAccountNamResultnull") != null)
						r.setUserName((String) attributes.get("sAMAccountName")
								.get());

					if (attributes.get("givenName") != null)
						r.setFirstName((String) attributes.get("givenName")
								.get());

					if (attributes.get("sn") != null)
						r.setLastName((String) attributes.get("sn").get());

					if (attributes.get("title") != null)
						r.setTitle((String) attributes.get("title").get());

					if (attributes.get("physicalDeliveryOfficeName") != null)
						r.setPhysicalDeliveryOfficeName((String) attributes.get(
								"physicalDeliveryOfficeName").get());

					if (attributes.get("department") != null)
						r.setDepartment((String) attributes.get("department")
								.get());

					if (attributes.get("company") != null)
						r.setCompany((String) attributes.get("company").get());

					if (attributes.get("telephoneNumber") != null)
						r.setTelephoneNumber((String) attributes.get(
								"telephoneNumber").get());

					if (attributes.get("mail") != null)
						r.setEmail((String) attributes.get("mail").get());

					list.add(r);
				}
			}
		}catch(IntrusionException exp1)
		 {
			if(log.isErrorEnabled()){
				log.error("ADQuery->IntrusionException for user:"+userName+": "+exp1);
			}
	     } 
		catch (NamingException exp2) {
			if(log.isErrorEnabled()){
				log.error("ADQuery->Naming Exception Occured for userName:"+userName+": "+exp2);
			}
		} finally {
			try {
				if(ldapContext != null )
					ldapContext.close();
			} catch (Exception exp3) {
				if(log.isErrorEnabled()){
					log.error("ADQuery->Exception while closing ldapContext for user:"+userName+": "+exp3);
				}
			}
		}
		return list;
	}

}
