package gov.va.med.mhv.sm.api.util;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.sm.api.cache.CacheHandler;
import gov.va.med.mhv.sm.api.enumeration.ErrorEnum;
import gov.va.med.mhv.sm.api.transfer.ErrorTO;
import gov.va.med.mhv.sm.api.transfer.Session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Random;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;

public class SMApiUtility {
	
	public static String SECRETKEY_ALGO="PBEWithMD5AndDES";
	public static String CIPHER_PADDING="PBEWithMD5AndDES";
	
	public static String SALT_VALUE_KEY="salt.value";
	public static String GENERAL_VALUE_KEY="general.key";

	
	public static String RFC1123_PATTERN  =	"EEE, dd MMM yyyy HH:mm:ss z";
	
	public static String getValueOfHeaderElement(HttpHeaders headers, String elementKey) {
		String elementValue = headers.getHeaderString(elementKey);
		return elementValue;
	}

	public static String encrypt(Session session) throws Exception {
		
		PBEKeySpec pbeKeySpec;
		PBEParameterSpec pbeParamSpec;
		SecretKeyFactory keyFac;
		byte[] ciphertext = null;
	
		Properties p = PropertiesHelper.getProperties();
		
        String saltValue = p.getProperty(SALT_VALUE_KEY);
		
		byte[] salt = saltValue.getBytes();
		Random random = new Random();
		random.nextBytes(salt);
		try {
			// Iteration count
	        int count = 10;

	        // Create PBE parameter set
	        pbeParamSpec = new PBEParameterSpec(salt, count);
			
	        String generalKey = p.getProperty(GENERAL_VALUE_KEY);
	        pbeKeySpec = new PBEKeySpec(generalKey.toCharArray());
	        keyFac = SecretKeyFactory.getInstance(SECRETKEY_ALGO);
	        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);

	        // Create PBE Cipher
	        Cipher pbeCipher = Cipher.getInstance(CIPHER_PADDING);

	        // Initialize PBE Cipher with key and parameters
	        pbeCipher.init(Cipher.ENCRYPT_MODE, pbeKey, pbeParamSpec);

	        // Our cleartext
	        byte[] cleartext = session.marshall();

	        // Encrypt the cleartext
	        ciphertext = pbeCipher.doFinal(cleartext);
	        
		} catch (Exception eX) {
			throw new Exception("Unable to create session token",eX);
		}
		
		String saltString = new String(Base64.encodeBase64(salt, false));
		String ciphertextString = new String(Base64.encodeBase64(ciphertext, false));

		return saltString+ciphertextString;
		
	}

	public static Session decrypt(String ciphertext) throws Exception {
		PBEKeySpec pbeKeySpec;
		PBEParameterSpec pbeParamSpec;
		SecretKeyFactory keyFac;
		Properties p = PropertiesHelper.getProperties();
//		String saltValue = p.getProperty(SALT_VALUE_KEY);
//		byte[] salt = saltValue.getBytes();
		Session session = null;
		
		// Iteration count
        int count = 10;

        //ADDing something new....
    	// Begin by splitting the text into salt and text Strings
		// salt is first 12 chars, BASE64 encoded from 8 bytes.
		String salt2 = ciphertext.substring(0,12);
		String ciphertext2 = ciphertext.substring(12,ciphertext.length());

		// BASE64Decode the bytes for the salt and the ciphertext
		byte[] saltArray = Base64.decodeBase64(salt2.getBytes());
		byte[] ciphertextArray = Base64.decodeBase64(ciphertext2.getBytes());
        
        // Create PBE parameter set
        pbeParamSpec = new PBEParameterSpec(saltArray, count);
        String generalKey = p.getProperty(GENERAL_VALUE_KEY);
        pbeKeySpec = new PBEKeySpec(generalKey.toCharArray());
        keyFac = SecretKeyFactory.getInstance(SECRETKEY_ALGO);
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);

        // Create PBE Cipher
        Cipher pbeCipher = Cipher.getInstance(CIPHER_PADDING);
        // Initialize PBE Cipher with key and parameters
        pbeCipher.init(Cipher.DECRYPT_MODE, pbeKey, pbeParamSpec);
        // Encrypt the cleartext
        //byte[] clearText1 = pbeCipher.doFinal(Base64.decode(ciphertextArray	));
        byte[] clearText1 = pbeCipher.doFinal(ciphertextArray);
        
        session = Session.unmarshall(clearText1);
		return session;
	
	}

	public static void throwExceptionOnErrors(ErrorEnum errorEnum, ServiceResponse<?> response) throws WebApplicationException {
		if( response.getMessages().getErrorMessageCount() > 0 ) {
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);
	
			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			Collection<Message> msgs = (Collection<Message>)response.getMessages().getErrorMessages();
			for(Message message: msgs) {
				sb.append(message.getSeverity()+":"+message.getKey()+";");
			}
			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);

			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
		}
	}
	
	public static void throwExceptionOnErrors(ErrorEnum errorEnum, CollectionServiceResponse<?> response) throws WebApplicationException {
		if( response.getMessages().getErrorMessageCount() > 0 ) {
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);
	
			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			Collection<Message> msgs = (Collection<Message>)response.getMessages().getErrorMessages();
			for(Message message: msgs) {
				sb.append(message.getSeverity()+":"+message.getKey()+";");
			}
			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);
			
			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
		}
	}
	
	public static void throwException(ErrorEnum errorEnum) throws WebApplicationException {
		ResponseBuilderImpl builder = new ResponseBuilderImpl();
		builder.status(400);

		ErrorTO error = new ErrorTO(errorEnum);
		CacheHandler.getInstance().setError(error);
		
		Response responseException = builder.build();
		throw new WebApplicationException(responseException);
	}

    public static void throwException(ErrorEnum errorEnum, String devMessage) throws WebApplicationException {
        ResponseBuilderImpl builder = new ResponseBuilderImpl();
        builder.status(400);

        ErrorTO error = new ErrorTO(errorEnum);
        error.setDeveloperMessage(devMessage);
        CacheHandler.getInstance().setError(error);
        
        Response responseException = builder.build();
        throw new WebApplicationException(responseException);
    }

	public static byte[] extractByteArray(final InputStream inputStream) throws IOException {
	    ByteArrayOutputStream buffer = new ByteArrayOutputStream();

	    byte[] dataChunk = new byte[1024 * 16];
	    int numRead = 0;
	    while (numRead != -1) {
	        numRead = inputStream.read(dataChunk, 0, dataChunk.length);

	        if (numRead != -1) {
	            buffer.write(dataChunk, 0, numRead);
	        }
	    }

	    buffer.flush();
	    return buffer.toByteArray();
	}
	
	public static String convertDateToRFC1123Pattern(Date dt ) {
		SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_PATTERN);
		String reportDate = formatter.format(dt);
		return reportDate;

	}

}
