package gov.va.med.mhv.sm.api.transfer;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.http.client.utils.DateUtils;

@XmlRootElement(name = "User")
public class PatientUserTO extends UserTO implements Serializable {
	private static final long serialVersionUID = -4149428769281580231L;

	private String nssn;
	private Date dob;
	private String street1;
	private String street2;
	private String city;
	private String state;
	private String zip;
	private Long dfn;

	public PatientUserTO() {
		super();
	}

	public PatientUserTO(Long id, String firstName, String lastName, String nssn, Date dob) {
		super(firstName,lastName, id, null);
		this.nssn = nssn;
		this.dob = dob;
	}
	public PatientUserTO(Long id, String firstName, String lastName,
			String nssn, Date dob, String phone, String street1,
			String street2, String city, String state, String zip, Long dfn) {
		super(firstName,lastName, id, phone);
		this.nssn = nssn;
		this.dob = dob;
		this.street1 = street1;
		this.street2 = street2;
		this.city = city;
		this.state = state;
		this.zip = zip;
		this.dfn = dfn;
	}

	public String getNssn() {
		return nssn;
	}

	public void setNssn(String nssn) {
		this.nssn = nssn;
	}

	public String getDob() {
		return (dob!=null?DateUtils.formatDate(dob):"");
	}

	public void setDob(Date dob) {
		this.dob = dob;
	}

	public String getStreet1() {
		return street1;
	}

	public void setStreet1(String street1) {
		this.street1 = street1;
	}

	public String getStreet2() {
		return street2;
	}

	public void setStreet2(String street2) {
		this.street2 = street2;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	public Long getDfn() {
		return dfn;
	}

	public void setDfn(Long dfn) {
		this.dfn = dfn;
	}

}
