package gov.va.med.mhv.sm.api.transfer;

import gov.va.med.mhv.sm.model.Clinician;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "User")
public class ClinicianUserTO extends UserTO implements Serializable {
	private static final long serialVersionUID = -3371240213438964691L;

	private String facility;
	private String department;
	private String username;

	public ClinicianUserTO() {
	}
	
	public ClinicianUserTO(Clinician c) {
		if( c != null ) {
			setId(c.getId());
			setUsername(c.getUsername());
			setFirstName(c.getFirstName());
			setLastName(c.getLastName());
			setFacility(c.getStationNo());
		}
	}
	
	public ClinicianUserTO(Long id, String username, String firstName, String lastName, String facility) {
		super(firstName, lastName, id, null);
		this.username = username;
	}
	
	public ClinicianUserTO(Long id, String username, String firstName, String lastName,
			 String facility, String department, String phone) {
		super(firstName, lastName, id, phone);
		this.facility = facility;
		this.department = department;
		this.username = username;
	}

	public String getFacility() {
		return facility;
	}

	public void setFacility(String facility) {
		this.facility = facility;
	}

	public String getDepartment() {
		return department;
	}

	public void setDepartment(String department) {
		this.department = department;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

}
