package gov.va.med.mhv.sm.api.patient;

import gov.va.med.mhv.sm.api.transfer.MessageCategoryTypesTO;
import gov.va.med.mhv.sm.api.transfer.MessagesTO;
import gov.va.med.mhv.sm.api.transfer.PatientMessageTO;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;

@Produces({"application/octet-stream","application/xml","application/json"})
@Consumes({"multipart/form-data","application/xml","application/json"})
public interface MessageAPIService {

	@POST
	@Path("/")
	public PatientMessageTO sendMessage(PatientMessageTO message);
	
	@POST
	@Path("/attach")
	public PatientMessageTO sendMessageWithAttachment( @Multipart(value = "message") PatientMessageTO message, List<Attachment> attachments );
	
	@POST
	@Path("/{messageId}")
	public Response deleteMessage(@javax.ws.rs.PathParam("messageId") Long messageId);

	@POST
	@Path("/{messageId}/move/tofolder/{folderId}")
	public Response moveMessage(@javax.ws.rs.PathParam("messageId") Long messageId, @javax.ws.rs.PathParam("folderId") Long folderId);
	
	@GET
	@Path("/{messageId}/attachment/{attachmentId}")
	public Response getMessageAttachment(@javax.ws.rs.PathParam("messageId") Long messageId, @javax.ws.rs.PathParam("attachmentId") Long attachmentId); //MultipartBody
	
	@POST
	@Path("/{messageId}/reply")
	public PatientMessageTO replyMessage(@javax.ws.rs.PathParam("messageId") Long messageId, PatientMessageTO message);
	
	@POST
	@Path("/{messageId}/reply/attach")
	public PatientMessageTO replyMessageWithAttachment(@javax.ws.rs.PathParam("messageId") Long messageId, @Multipart(value = "message") PatientMessageTO message, List<Attachment> attachments );
	
	@GET
	@Path("/{messageId}/read")
	public PatientMessageTO readMessage(@javax.ws.rs.PathParam("messageId") Long messageId);
	
	@GET
	@Path("/{messageId}/history")
	public MessagesTO getMessageHistory( @javax.ws.rs.PathParam("messageId") Long messageId );

	@POST
	@Path("/draft")
	public PatientMessageTO saveDraftMessage(PatientMessageTO message);

	@POST
	@Path("/{messageId}/replydraft")
	public PatientMessageTO saveReplyDraft(@javax.ws.rs.PathParam("messageId") Long currentMessageId, PatientMessageTO message);	
	
	@GET
	@Path("/category")
	public MessageCategoryTypesTO getMessageCategoryTypes();
	
}
