package gov.va.med.mhv.sm.api.enumeration;

import java.util.Arrays;
import java.util.List;

public enum ErrorEnum {
	UNKNOWN_99 (99,"Unknown application error occurred"), 
	BODY_CANT_BE_NULL_100 (100, "The message body cannot be blank"),
	APPLICATION_AUTHENTICATION_FAILED_101 (101,"Application authentication failed"),
	APPLICATION_AUTHORIZATION_FAILED_102 (102,"Application authorization failed"),
	INVALID_USER_CREDENTIALS_103 (103,"Invalid User Credentials"),
	MISSING_USER_CREDENTIALS_104 (104,"Missing User Credentials"),
	USER_NOT_FOUND_105 (105, "User was not found"), 
	INELIGIBLE_USER_REASON_BLOCKED_106 (106, "User is not eligible because they are blocked"),
	UNABLE_TO_CREATE_TOKEN_107 (107, "System unable to create token"),
	MISSING_SESSION_TOKEN_108 (108, "Missing session token"), 
	INVALID_SESSION_TOKEN_109 (109,"Invalid session token"), 
	EXPIRED_SESSION_TOKEN_110 (110, "Expired session token"), 
	INVALID_USER_PERMISSIONS_111 (111,"Invalid user permissions"), 
	NOT_OWNER_OF_ENTITY_112 (112, "User is not owner of entity requested"), 
	MESSAGE_ATTACHMENT_ERROR_113 (113, "Unable to read attachment"), 
	MESSAGE_MOVE_ERROR_114 (114, "Unable to move message"),
	NOT_FOUND_115 (115, "Entity Not Found"),
	FOLDER_MUST_BE_EMPTY_BEFORE_DELETE_116 (116, "The Folder must be empty before delete"),
	DATA_INTEGRITY_ERROR_117 (117,"A data integrity issue was encountered"), 
	NOT_ABLE_TO_MOVE_DRAFT_MESSAGES_118 (118, "It is not possible to move a message from the DRAFTS folder"),
	TRIAGE_TEAM_NOT_FOUND_119 (119, "Triage team does not exist"),
	PAGE_NUMBER_MUST_BE_GREATER_THAN_ZERO_120 (120, "The Page Number must be greater than zero"), 
	PAGE_SIZE_MUST_BE_GREATER_THAN_ZERO_121 (121, "The Page Size must be greater than zero"),
	UNSUPPORTED_ATTACHMENT_FILE_TYPE_122 (122, "The attachment file type is currently not supported"),
	FILENAME_IS_REQUIRED_123 (123, "The filename is a required parameter"),
	MESSAGE_ATTACHMENT_EXCEEDS_SIZE_124 (124, "The attachment file size exceeds the supported size limits"),
	FOLDER_REQUIRES_NAME_125 (125, "To create a folder the name is required"),
	FOLDER_ALREADY_EXISTS_126 (126, "The Folder Already Exists With the Requested Name"),
	FOLDER_REQUIRES_ALPHANUMERIC_NAME_127 (127, "The folder name should only contain letters, numbers, and spaces"),
	MESSAGE_IS_NOT_A_DRAFT_SEND_128 (128, "The message you are attempting to send is not a draft"), 
	UNABLE_TO_REPLY_NOT_ASSOCIATED_TRIAGE_TEAM_129 (129, "Unable to reply because you are no longer associated with this Triage Team"),
	UNABLE_TO_REPLY_EXPIRED_MESSAGE_130 (130, "Unable to reply because the source message is expired"),
	UNABLE_TO_REPLY_TO_A_DRAFT_MESSAGE_131 (131, "Unable to reply to a message that is a draft"),
	MISSING_APPLICATION_TOKEN_132 (132, "Missing application token"),
	PAGE_SIZE_EXCEEDS_LIMIT_133(133,"PageSize exceeds the maximum allowed limit"),
	MESSAGE_IS_NOT_A_DRAFT_SAVE_134 (134, "The message you are attempting to save is not a draft"),
	INELIGIBLE_USER_REASON_NOT_OPTED_IN_OR_T_C_135 (135, "User is not eligible because they have not accepted terms and conditions or opted-in"),
	MESSAGE_MOVE_ERROR_136 (136, "Unable to Delete Draft Message"),
	USER_BLOCKED_FACILITY_151 (151, "User is blocked from the Facility"),
	
	//For Clinician
	MESSAGE_RECEIPIENT_EMPTY_ERROR_137 (137, "The recipient has not been identified"),
	MESSAGE_RECEIPIENT_NOT_FOUND_138 (138, "The recipient has not been found"),
	
	
	PARAMETERS_CANNOT_BE_EMPTY_139 (139, "Parameter's cannot all be empty"),
	MESSAGE_RECEIPIENT_NOT_SET_140 (140, "The recipient has not been set or does not exist"),
	
	MESSAGE_FORWARD_NOT_ALLOWED_TO_PATIENT_141 (141, "Forwarding a message to patient is not allowed"),
	MESSAGE_FORWARD_NOT_ALLOWED_TO_DIST_GRP_142 (142, "Forwarding a message to DISTRIBUTION GROUP is not allowed"),
	MESSAGE_FORWARD_NOT_ALLOWED_TO_CC_143 (143, "Forwarding a message with CC is not allowed"),
	MESSAGE_TIU_ERROR_144 (144, "The system is busy processing a previous request to save this message. Please try again later"),
	MESSAGE_TIU_ERROR_145 (145, "The system is unable processing your request"),
	NO_MESSAGE_FOR_TIU_SELECTED_145(145, "No Message has been selected for TIU Posting"),
	EROR_ASSIGNING_MESSAGE_INTIU_146(146, "Error while trying to assign a message to a Clinician in while posting the TIU Notes"),
	
	MESSAGE_RECEIPIENT_NOT_ALLOWED_147 (147, "Reply to Distribution group is not allowed"),
	
	MESSAGE_REASSIGNED_NOT_ALLOWED_148 (148, "This Message is not allowed to be Reassigned"),
	USER_IS_BLOCKED_FROM_TRIAGE_GROUP_149 (149, "Patient is blocked from the Triage Group"),
	NO_TRIAGE_GROUP_FOR_CLINICIAN (150, "No Triage Group is Associated with the requested Clinician"),
	
	//SERVICES
	MAILBOX_SERVICE_ERROR_900 (900, "Mailbox Service Error"),
	AUTHENTICATION_SERVICE_ERROR_901 (901, "Authentication Service Error"),
	TRIAGEGROUP_SERVICE_ERROR_902 (902, "Triage Group Service Error"),
	SEND_MESSAGE_SERVICE_ERROR_903 (903, "Send Message Service Error"),
	MESSAGE_SERVICE_ERROR_904 (904, "Message Service Error"),
	DISTRIBUTION_GROUP_SERVICE_ERROR_905 (905, "Distribution Group Service Error"),
	USER_MANAGEMENT_SERVICE_ERROR_906 (906, "User Management Service Error");
	
	private int id;
	private String errorMessage;
	private Class<?> clazz;
	
	private ErrorEnum() {
	}
	
	private ErrorEnum(int id, String errorMessage){
		this.id = id;
		this.errorMessage = errorMessage;
		this.clazz = null;
	}
	private ErrorEnum(int id, String errorMessage, Class<?> clazz){
		this.id = id;
		this.errorMessage = errorMessage;
		this.clazz = clazz;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getErrorMessage() {
		return errorMessage;
	}
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	public Class<?> getClazz() {
		return clazz;
	}
	public void setClazz(Class<?> clazz) {
		this.clazz = clazz;
	}
	
	public static ErrorEnum valueOf(int id) throws Exception {
		for(ErrorEnum f : ErrorEnum.values()){
			if(f.getId()==(id))
				return f;
		}
		/* none found; throw error */
		throw new Exception("No SourceEnum found matching " + id);
	}
	
	public static List<ErrorEnum> toList(){
		return Arrays.asList(ErrorEnum.values());
	}
}
