package gov.va.med.mhv.sm.api.clinician.impl;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.sm.api.clinician.TriageTeamAPIService;
import gov.va.med.mhv.sm.api.common.SessionAPIService;
import gov.va.med.mhv.sm.api.enumeration.ErrorEnum;
import gov.va.med.mhv.sm.api.transfer.ClinicianTriageTeamTO;
import gov.va.med.mhv.sm.api.transfer.ClinicianUserTO;
import gov.va.med.mhv.sm.api.transfer.Session;
import gov.va.med.mhv.sm.api.transfer.TriageTeamTO;
import gov.va.med.mhv.sm.api.transfer.TriageTeamsTO;
import gov.va.med.mhv.sm.api.transfer.UserTO;
import gov.va.med.mhv.sm.api.transfer.UsersTO;
import gov.va.med.mhv.sm.api.util.SMApiUtility;
import gov.va.med.mhv.sm.dto.UserSurrogateDTO;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Resource;

import org.apache.cxf.jaxrs.ext.MessageContext;

public class TriageTeamAPIServiceImpl implements TriageTeamAPIService {
	private SessionAPIService sessionApiService;
	private UserManagementService userManagementService;
	private TriageGroupService triageGroupService;

	@Resource
	MessageContext mc;

	/*
	 * Session Error Codes: 108, 109, 110, 111
	 */
	@Override
	public TriageTeamsTO getTriageTeams() {
		Session session = sessionApiService.checkSession(mc);
		Clinician c = (Clinician)session.getClinician();

		List<TriageTeamTO> TeamArray = new ArrayList<TriageTeamTO>();
		for(TriageGroup tg : c.getGroups()) {
			TeamArray.add(new ClinicianTriageTeamTO(tg.getId(), tg.getName(), tg.getVistaDiv()));
		}

		return new TriageTeamsTO(TeamArray);
	}

	@Override
	public UsersTO getMembersForTriageTeam(Long triageTeamId) {
		Session session = sessionApiService.checkSession(mc);
		Clinician c = (Clinician) session.getClinician();

		UsersTO usersTO = new UsersTO();

		boolean foundTeam = false;
		for(TriageGroup tg : c.getGroups()) {
			if( tg.getId().equals(triageTeamId) ) {
				foundTeam = true;
				break;
			}
		}

		if( !foundTeam ) {
			SMApiUtility.throwException(ErrorEnum.TRIAGE_TEAM_NOT_FOUND_119);
		}

		CollectionServiceResponse<UserSurrogateDTO> response = userManagementService.getTriageMembersWithCurrentSurrogate(triageTeamId);
		Collection<UserSurrogateDTO> userSurrogateList = response.getCollection();
		boolean userExists=false;
		for(UserSurrogateDTO userSurrogate:userSurrogateList){
			if(userSurrogate.getUserId().equals(c.getId())){
				userExists=true;
				break;
			}
		}
		if(!userExists){
			UserSurrogateDTO userSurrogateDTO= new UserSurrogateDTO();
			userSurrogateDTO.setName(c.getName());
			userSurrogateDTO.setSurrogateName("");
			userSurrogateDTO.setUserId(c.getId());
			userSurrogateList.add(userSurrogateDTO);
		}
		Collection<UserSurrogateDTO> list = response.getCollection();

		List<UserTO> userArray = new ArrayList<UserTO>();
		for( UserSurrogateDTO user: list ) {
			//user0.LAST_NAME || ', ' || user0.FIRST_NAME
			String names[] = split(user.getName(),", ");
			userArray.add(new ClinicianUserTO(user.getUserId(),null,names[1],names[0],null));
		}
		usersTO.setUser(userArray);

		return usersTO;
	}

	/**
	 * LAST, FIRST
	 * @param s
	 * @param delim
	 * @return
	 */
	private static String[] split( String s, String delim) {
		String[] res = new String[2];
		int indx = s.indexOf(delim);
		if( indx == 0 ) {
			//no last name
			res[0] = "";
			res[1] = s.substring(delim.length());
		} else if (indx == (s.length()-delim.length()) ){
			//no first name
			res[1] = "";
			res[0] = s.substring(0,s.length()-delim.length());
		} else {
			res = s.split(delim,2);
		}

		return res;
	}

	@Override
	public TriageTeamsTO getTriageTeamsForFacility( String stationNumber ) {
		Session session = sessionApiService.checkSession(mc);
		Clinician c = (Clinician) session.getClinician();

		CollectionServiceResponse<TriageGroup> response = triageGroupService.getTriageGroupsForStation(stationNumber);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response);

		List<TriageTeamTO> TriageTeamArray = new ArrayList<TriageTeamTO>();
		for(TriageGroup tg : c.getGroups()) {
			TriageTeamArray.add(new ClinicianTriageTeamTO(tg.getId(), tg.getName(), tg.getVistaDiv()));
		}

		return new TriageTeamsTO(TriageTeamArray);
	}

	public SessionAPIService getSessionApiService() {
		return sessionApiService;
	}
	public void setSessionApiService(SessionAPIService sessionService) {
		this.sessionApiService = sessionService;
	}
	public UserManagementService getUserManagementService() {
		return userManagementService;
	}
	public void setUserManagementService(UserManagementService userManagementService) {
		this.userManagementService = userManagementService;
	}
	public TriageGroupService getTriageGroupService() {
		return triageGroupService;
	}
	public void setTriageGroupService(TriageGroupService triageGroupService) {
		this.triageGroupService = triageGroupService;
	}

}
