package gov.va.med.mhv.sm.api.clinician;

import java.util.List;

import gov.va.med.mhv.sm.api.transfer.ClinicianSearchFormTO;
import gov.va.med.mhv.sm.api.transfer.ClinicianUserTO;
import gov.va.med.mhv.sm.api.transfer.CommentTO;
import gov.va.med.mhv.sm.api.transfer.FacilityTO;
import gov.va.med.mhv.sm.api.transfer.ReAssignMessageHistoryTO;
import gov.va.med.mhv.sm.api.transfer.TriageGroupTO;
import gov.va.med.mhv.sm.api.transfer.VisnTO;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces({"application/xml","application/json"})
@Consumes({"application/xml","application/json"})
public interface ReAssignMessageAPIService {
	
	@GET
	@Path("/getvisn")
	public List<VisnTO> getVisnList();
	
	@GET
	@Path("/getfacility/{visnId}")
	public List<FacilityTO> getFicilityList(@javax.ws.rs.PathParam("visnId") Long visnId);

	/*
	 * using MessageId in order do some filtration based on the patient used
	 * Subtract the triage group(s) patient is blocked
	 * Set the indicator patient is associated with
	 */
	@GET
	@Path("/{messageId}/gettriagegrouplist")
	public List<TriageGroupTO> getinFacTriageGroupList(
							@javax.ws.rs.PathParam("messageId") Long messageId);
	@GET
	@Path("/{messageId}/gettriagegrouplist/{facilityId}")
	public List<TriageGroupTO> getOutFacTriageGroupList(
							@javax.ws.rs.PathParam("messageId") Long messageId, 
							@javax.ws.rs.PathParam("facilityId") Long facilityId);


	@POST
	@Path("/{messageId}/reassigntginfac/{triageGroupId}")
	public Response reassignToTGInFacility(
							@javax.ws.rs.PathParam("messageId") Long messageId, 
							@javax.ws.rs.PathParam("triageGroupId") Long triageGroupId, 
							CommentTO comment);
	

	@POST
	@Path("/{messageId}/reassigntgoutfac/{triageGroupId}")
	public Response reassignToTGOutFacility(
							@javax.ws.rs.PathParam("messageId") Long messageId, 
							@javax.ws.rs.PathParam("triageGroupId") Long triageGroupId, 
							CommentTO comment);
	
	@POST
	@Path("/{messageId}/reassignclinicianinfac/{triageGroupId}/{clinicianId}")
	public Response reassignToClinicianInFacility(
							@javax.ws.rs.PathParam("messageId") Long messageId,
							@javax.ws.rs.PathParam("triageGroupId") Long triageGroupId,
							@javax.ws.rs.PathParam("clinicianId") Long clinicianId, 
							CommentTO comment);
	
	@POST
	@Path("/{messageId}/reassignclinicianoutfac/{triageGroupId}/{clinicianId}")
	public Response reassignToClinicianOutFacility(
							@javax.ws.rs.PathParam("messageId") Long messageId,
							@javax.ws.rs.PathParam("triageGroupId") Long triageGroupId,
							@javax.ws.rs.PathParam("clinicianId") Long clinicianId, 
							CommentTO comment);
	
	
	@POST
	@Path("/searchclinicianinfac")
	public List<ClinicianUserTO> searchClinicianInFacility(ClinicianSearchFormTO form);

	@POST
	@Path("/searchclinicianoutfac/{facilityId}")
	public List<ClinicianUserTO> searchClinicianOutFacility(
							@javax.ws.rs.PathParam("facilityId") Long facilityId,	
							ClinicianSearchFormTO form);

	/*
	 *  Fetch the Triage Group the Clinicians are associated with 
	 *  in order to reassign the message
	 *  using MessageId in order do some filtration based on the patient used
	 *  Subtract the triage group(s) patient is blocked
	 *  Set the indicator patient is associated with 
	 */
	
	@GET
	@Path("/gettriagegroupbyclinicianinfac/{messageId}/{clinicianId}")
	public List<TriageGroupTO> getTriageGroupsByClinicianInFac(
			@javax.ws.rs.PathParam("messageId") Long messageId,
			@javax.ws.rs.PathParam("clinicianId") Long clinicianId);

	@GET
	@Path("/gettriagegroupbyclinicianoutfac/{messageId}/{clinicianId}")
	public List<TriageGroupTO> getTriageGroupsByClinicianOutFac(
			@javax.ws.rs.PathParam("messageId") Long messageId,
			@javax.ws.rs.PathParam("clinicianId") Long clinicianId);
	

	@GET
	@Path("/getreassignhistory/{messageId}")
	public List<ReAssignMessageHistoryTO> getReassignMessageHistory(
			@javax.ws.rs.PathParam("messageId") Long messageId);

	
}
