package gov.va.med.mhv.sm.api.clinician;

import java.util.List;

import gov.va.med.mhv.sm.api.transfer.FacilityTO;
import gov.va.med.mhv.sm.api.transfer.PatientSearchFormTO;
import gov.va.med.mhv.sm.api.transfer.PatientUserTO;
import gov.va.med.mhv.sm.api.transfer.UsersTO;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Produces({"application/xml","application/json"})
@Consumes({"application/xml","application/json"})
public interface PatientAPIService {
	
	@POST
	@Path("/search/page/{pageNumber}/pageSize/{pageSize}")
	public UsersTO searchUsers( PatientSearchFormTO form, @javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize);
	
	@GET
	@Path("/{userId}")
	public PatientUserTO getPatient( @javax.ws.rs.PathParam("userId") Long userId );

	/*
	 * patient id (userID ) requires to be fetched from message's senderId.
	 */
	@GET
	@Path("/{patientId}/getfacilitylist")
	public List<FacilityTO> getPatientFacilityList( @javax.ws.rs.PathParam("patientId") Long patientId );

	
}
