package gov.va.med.mhv.sm.api.clinician;

import java.util.List;

import gov.va.med.mhv.sm.api.transfer.ClinicianSearchFormTO;
import gov.va.med.mhv.sm.api.transfer.ClinicianUserTO;
import gov.va.med.mhv.sm.api.transfer.FacilityTO;
import gov.va.med.mhv.sm.api.transfer.PatientUserTO;
import gov.va.med.mhv.sm.api.transfer.UsersTO;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Produces({"application/xml","application/json"})
@Consumes({"application/xml","application/json"})
public interface ClinicianAPIService {
	
	@POST
	@Path("/search/page/{pageNumber}/pageSize/{pageSize}")
	public UsersTO searchUsers( ClinicianSearchFormTO form, @javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize);
	
	@GET
	@Path("/{userId}")
	public ClinicianUserTO getClinician( @javax.ws.rs.PathParam("userId") Long userId );

	@GET
	@Path("/currentclinician")
	public ClinicianUserTO getCurrentClinicianInfo();


}
