<%@ taglib uri="http://tiles.apache.org/tags-tiles" prefix="tiles"%>

<%@ page
  import="org.apache.commons.logging.Log"
  import="org.apache.commons.logging.LogFactory"
  import="gov.va.med.mhv.sm.model.Addressee"
  import="gov.va.med.mhv.sm.model.Folder"
  import="gov.va.med.mhv.sm.model.Message"
  import="gov.va.med.mhv.sm.model.MessagesPage"
  import="gov.va.med.mhv.sm.model.MailParticipant"
  import="gov.va.med.mhv.sm.model.User"
  import="gov.va.med.mhv.sm.model.Patient"
  import="gov.va.med.mhv.sm.model.Clinician"
  import="gov.va.med.mhv.sm.model.Thread"
  import="gov.va.med.mhv.sm.util.DateUtils"
  import="gov.va.med.mhv.sm.enumeration.SystemFolderEnum"
  import="gov.va.med.mhv.sm.web.actions.ViewStaffMessages"
%>
<%--
  This page should not be responsible for fetching the messages.
  Only for displaying the messages that happen to exist in the
  session("activeFolder").getMessagesPage()
--%>

<%--
  If we are in the drafts folder then the link for the message
  should be to compose (edit), not read message
--%>

<%!private static Log log =LogFactory.getLog("jsp.gov.va.med.mhv.sm.clinician_Inbox_messages");%>
<%
Folder folder=(Folder)request.getAttribute(ViewStaffMessages.CURRENT_FOLDER);
String activeFolderName = folder.getName();
MessagesPage messages = folder.getMessages();

if(messages == null){
	log.error("The messages object is not valid");
%>
  <tr><td colspan="7" valign="middle" align="center"><br /><strong>No Messages Found (Error Occurred)</strong><br />&nbsp;</td></tr>
<%
	return;
 }
 if(messages.getElementCount() == 0){
   %>
     <tr><td colspan="7" valign="middle" align="center"><br /><strong>No Messages Found</strong><br />&nbsp;</td></tr>
   <%
	return;
 }
boolean odd = false;
String unread = "";
for(Addressee a : messages.getElements()){
 if(a.getReadDate() == null){
  unread = "font-weight:bold;";
 }else{
  unread = "";
 }
 Message m = a.getMessage();
 Thread t = m.getThread();
 odd = !odd;
 String style = "";
 if(odd){
	style = "sm_inbox_odd";
 }else{
	style =  "sm_inbox_even";
 }
 %>

<tr class="<%=style %>">
  		<td style="<%=unread %>"><%= m.getSenderName() %></td>
	    <td style="<%=unread %>"><%= m.getRecipientName() %></td>
	    <td style="<%=unread %>">

	        <a href="viewStaffMessages_selectMessage.action?messageId=<%=m.getId() %>">
	    	  <%=t.getSubject()%>  
	        </a>&nbsp;&nbsp;
	        <%
	        	if(m.isAttachment()){
	        %>
	        <img src='images/attachment.gif' border="0"> 
	        <%}%>
	    </td>
	    <td style="<%=unread %>"><%=DateUtils.getEnglishDateTime( (folder.getId() == SystemFolderEnum.DRAFTS.getId()?m.getCreatedDate():m.getSentDate()) ) %></td>
	    <td>	<%
		    	if(m.getAssignedTo()==null){
		    		out.println("&nbsp;");
		    	}else{
		          out.println(m.getAssignedTo().getName());
		    	}
	    		%>
	    </td>	
	    
		<td><%=m.getStatus().getStatus() %>&nbsp;</td>
		<%	String readReceipt = m.getReadReceipt();
			if(readReceipt==null) readReceipt = "";%>	
		    <td><%=readReceipt %>&nbsp;</td>
	    <%}%>
</tr>
