package gov.va.med.mhv.sm.web.util;

import gov.va.med.mhv.sm.web.session.TriageRelationSession;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Locale;

public class TriageRelationHelper {

	
	
	public List getSortedTriageRelationList(Map resultMap)
    {
		Locale.setDefault(Locale.ENGLISH);
    	List<TriageRelationSession> resultList = new ArrayList<TriageRelationSession>();
    	for(Object key : resultMap.keySet() ) 
    	{
			Object value = resultMap.get(key);
			TriageRelationSession triageRelationSession = new TriageRelationSession();
			triageRelationSession.setResultId((String)key);
			triageRelationSession.setResultName((String)value);
			resultList.add(triageRelationSession);
		}
    	Collections.sort(resultList,TRIAGERELATION_SESSION_COMPARATOR);
    	
    	return resultList;
    }
	
	public static final Comparator<TriageRelationSession> TRIAGERELATION_SESSION_COMPARATOR = new Comparator<TriageRelationSession>() {
		public int compare(TriageRelationSession triageRelationSessObj1, TriageRelationSession triageRelationSessObj2) {
			if(triageRelationSessObj1 == null || triageRelationSessObj2 == null) return 0;
			int result = triageRelationSessObj1.getResultName().toUpperCase().compareTo(triageRelationSessObj2.getResultName().toUpperCase());
			return result;
		}
	};
	
}
