package gov.va.med.mhv.sm.web.util;

import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.util.DateUtils;

import javax.servlet.http.HttpSession;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


public class HtmlHelper {
	static String filler = "                    ";
	private HtmlHelper() {}

	public static String encode(String raw) {
		if ( raw == null ) return "";
		// Order matters here & must be first and line breaks last
		String result = raw.replaceAll("&", "&amp;");
		result = result.replaceAll(">", "&gt;");
		result = result.replaceAll("<", "&lt;");
		result = result.replaceAll("\"", "&quot;");
		result = result.replaceAll("\n", "<br />");
		return result;
	}


	public static String untabify(String s,int tabSize) 
    {
          StringBuffer result = new StringBuffer();
          String lfiller = filler.substring(0, tabSize);
          String lines[] = s.split("\n");
          for (String line : lines) {
                String[] chunks = line.split("\t");
                StringBuffer newline = new StringBuffer((chunks.length== 0? line:""));
                for (String chunk:chunks) {
                      int cur = (newline.length() + chunk.length());
                      newline.append(chunk).append(lfiller.substring(cur % tabSize));
                }
                result.append(newline).append("\n");
          }
          return result.toString();
    }
	
	public static String getPatientLastFourSSN(HttpSession session, Long userId)
    {
    	String patientSignature="";
    	UserDao userDao;
    	WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(session.getServletContext());
    	userDao = (UserDao)ctx.getBean("userDao");
        Patient patient  = userDao.findPatientById(userId);
        if(patient!=null){
        	patientSignature=" <i>[ SSN: ";
        	if(patient.getNssn()!=null){
        		patientSignature = patientSignature+patient.getNssn().substring(1,5);
        	}

        	if(patient.getDob()!=null){
        		patientSignature = patientSignature+", DOB: "+DateUtils.getEnglishDate(patient.getDob());
        	}
        	patientSignature = patientSignature+" ]</i>";
        }
        userDao=null;
        patient=null;
        ctx=null;
        return patientSignature;
    }
}
