package gov.va.med.mhv.sm.web.util;

import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.foundation.service.response.messages.MessageUtils;
import gov.va.med.mhv.foundation.service.response.messages.Messages;
import gov.va.med.mhv.foundation.util.DescriptionBuilder;
import gov.va.med.mhv.foundation.util.Precondition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.opensymphony.xwork2.ActionSupport;

/**
 * Default message handler implementation - handles messages by making
 * them accessible in the Struts action.
 */
public class DefaultMessagesHandler implements MessagesHandler {
	
	private static final Log LOG = LogFactory.getLog(DefaultMessagesHandler.
		class);

	@SuppressWarnings("unchecked")
	public void handleMessages(Messages messages, Class<?> clazz, 
        ActionSupport actionSupport) 
    {
		Precondition.assertNotNull("messages", messages);
		Precondition.assertNotNull("clazz", clazz);
		Precondition.assertNotNull("actionSupport", actionSupport);
		
		if (messages.hasErrorMessages()) {
			for (String message: createFormattedMessages(messages.
					getErrorMessages(), // "unchecked" 
					clazz, actionSupport))
			{
				actionSupport.addActionError(message); 
			}
		}

		if (messages.hasInformationalMessages()) {
			for (String message: createFormattedMessages(messages.
					getInformationalMessages(), // "unchecked" 
					clazz, actionSupport))
			{
				actionSupport.addActionMessage(message); 
			}
		}
	}

    protected List<String> createFormattedMessages(Collection<Message> messages, 
    	Class<?> clazz, ActionSupport actionSupport)
    {
        List<String> formattedMessages = new ArrayList<String>();
        if (messages != null) {
            for (Message message: messages) {
                String formattedMessage = null;
                try {
                	formattedMessage = MessageUtils.getSummaryMessage(
                		message.getKey(), message.getInserts(), clazz, 
                		actionSupport.getLocale());
                } catch(java.util.MissingResourceException e) {
                	LOG.error("Unable to format propertly message: key: " + 
                		message.getKey() + "; inserts: " + DescriptionBuilder.
                		describe(message.getInserts()) + "class: " + clazz +
                		"; locale: " + actionSupport.getLocale() + 
                		". Using key instead.", e);
                	formattedMessage = message.getKey();
                }
                if (!StringUtils.isBlank(formattedMessage)) {
                    formattedMessages.add(formattedMessage);
                }
            }
        }
        return formattedMessages;
    }

}
