package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.sm.enumeration.CountsSubCategoryEnum;
import gov.va.med.mhv.sm.enumeration.ListsSubCategoryEnum;
import gov.va.med.mhv.sm.enumeration.RoleScopeEnum;
import gov.va.med.mhv.sm.util.RotateListUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportHelper {

	public static final int COLUMNS = 3;
	
	private static Map<RoleScopeEnum,Object[]> countsSequencesMap = new HashMap<RoleScopeEnum,Object[]>();
	private static Map<RoleScopeEnum,Object[]> listsSequencesMap = new HashMap<RoleScopeEnum,Object[]>();
	
	
	public static synchronized Object[] getSequenceForCountsAndTrends(RoleScopeEnum role) {
		if( !countsSequencesMap.containsKey(role) ) {
			countsSequencesMap.put(role,RotateListUtil.rotate(COLUMNS,filterCountsAndTrends(role)));
		}
		return countsSequencesMap.get(role); 
	}
	
	public static CountsSubCategoryEnum[] filterCountsAndTrends(RoleScopeEnum role) {
		CountsSubCategoryEnum[] filteredFields = null;

		switch(role){
		case NATIONAL:
			filteredFields = new CountsSubCategoryEnum[] {
//					CountsAndTrendsFieldEnum.ACTION_PENDING_PATIENTS,
					//CountsSubCategoryEnum.ACTIVE_PATIENTS,
//					CountsAndTrendsFieldEnum.ASSOCIATED_PATIENTS,
					CountsSubCategoryEnum.BLOCKED_PATIENTS,
					CountsSubCategoryEnum.CPRS_TIU_PROGRESS_NOTE,
//					CountsAndTrendsFieldEnum.FIRST_MESSAGE_RESOLUTION_RATE,
					//CountsSubCategoryEnum.INACTIVE_PATIENTS,
					CountsSubCategoryEnum.INBOUND_MESSAGE_VOLUME,
//					CountsSubCategoryEnum.MESSAGE_COMPLETION_BY_USER_TYPE,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_PROVIDER,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_TEAMMEMBER,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_TRIAGESTAFF,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_AVG,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_MAX,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_MIN,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_VOLUME,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_WITHIN_TARGET,
					CountsSubCategoryEnum.MESSAGE_ESCALATION,
//					CountsSubCategoryEnum.MESSAGE_MANAGEMENT_BY_USER_TYPE,
//					CountsAndTrendsFieldEnum.MESSAGE_STATUS_SUMMARY,
					CountsSubCategoryEnum.MESSAGE_THREADS,
					CountsSubCategoryEnum.MESSAGE_TYPES_APPOINTMENT,
					CountsSubCategoryEnum.MESSAGE_TYPES_GENERAL,
					CountsSubCategoryEnum.MESSAGE_TYPES_MEDICATION,
					CountsSubCategoryEnum.MESSAGE_TYPES_TEST,
					CountsSubCategoryEnum.MESSAGE_TYPES_EDUCATION,
					CountsSubCategoryEnum.OPTED_IN_PATIENTS,
//					CountsAndTrendsFieldEnum.OPTED_OUT_PATIENTS,
					CountsSubCategoryEnum.OUTBOUND_MESSAGE_VOLUME,
					//CountsSubCategoryEnum.SM_HEALTHCARE_TEAMS,
					CountsSubCategoryEnum.TOTAL_MESSAGE_VOLUME,
					CountsSubCategoryEnum.UNIQUE_PATIENT_SENDERS,
					CountsSubCategoryEnum.UNIQUE_TEAM_MEMBERS_SENDERS
					};
			break;
		case VISN:
			filteredFields = new CountsSubCategoryEnum[] {
					CountsSubCategoryEnum.ACTION_PENDING_PATIENTS,
					//CountsSubCategoryEnum.ACTIVE_PATIENTS,
//					CountsAndTrendsFieldEnum.ASSOCIATED_PATIENTS,
					CountsSubCategoryEnum.BLOCKED_PATIENTS,
					CountsSubCategoryEnum.CPRS_TIU_PROGRESS_NOTE,
					CountsSubCategoryEnum.FIRST_MESSAGE_RESOLUTION_RATE,
					//CountsSubCategoryEnum.INACTIVE_PATIENTS,
					CountsSubCategoryEnum.INBOUND_MESSAGE_VOLUME,
//					CountsSubCategoryEnum.MESSAGE_COMPLETION_BY_USER_TYPE,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_PROVIDER,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_TEAMMEMBER,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_TRIAGESTAFF,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_AVG,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_MAX,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_MIN,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_VOLUME,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_WITHIN_TARGET,
					CountsSubCategoryEnum.MESSAGE_ESCALATION,
//					CountsSubCategoryEnum.MESSAGE_MANAGEMENT_BY_USER_TYPE,
//					CountsAndTrendsFieldEnum.MESSAGE_STATUS_SUMMARY,
					CountsSubCategoryEnum.MESSAGE_THREADS,
					CountsSubCategoryEnum.MESSAGE_TYPES_APPOINTMENT,
					CountsSubCategoryEnum.MESSAGE_TYPES_GENERAL,
					CountsSubCategoryEnum.MESSAGE_TYPES_MEDICATION,
					CountsSubCategoryEnum.MESSAGE_TYPES_TEST,
					CountsSubCategoryEnum.MESSAGE_TYPES_EDUCATION,
					CountsSubCategoryEnum.OPTED_IN_PATIENTS,
					CountsSubCategoryEnum.OPTED_OUT_PATIENTS,
					CountsSubCategoryEnum.OUTBOUND_MESSAGE_VOLUME,
					//CountsSubCategoryEnum.SM_HEALTHCARE_TEAMS,
					CountsSubCategoryEnum.TOTAL_MESSAGE_VOLUME,
					CountsSubCategoryEnum.UNIQUE_PATIENT_SENDERS,
					CountsSubCategoryEnum.UNIQUE_TEAM_MEMBERS_SENDERS };
			break;
		case FACILITY:
			filteredFields = new CountsSubCategoryEnum[] {
					CountsSubCategoryEnum.ACTION_PENDING_PATIENTS,
					//CountsSubCategoryEnum.ACTIVE_PATIENTS,
					CountsSubCategoryEnum.ASSOCIATED_PATIENTS,
					CountsSubCategoryEnum.BLOCKED_PATIENTS,
					CountsSubCategoryEnum.CPRS_TIU_PROGRESS_NOTE,
					CountsSubCategoryEnum.FIRST_MESSAGE_RESOLUTION_RATE,
					//CountsSubCategoryEnum.INACTIVE_PATIENTS,
					CountsSubCategoryEnum.INBOUND_MESSAGE_VOLUME,
//					CountsSubCategoryEnum.MESSAGE_COMPLETION_BY_USER_TYPE,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_PROVIDER,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_TEAMMEMBER,
					CountsSubCategoryEnum.MESSAGE_COMPLETED_BY_TRIAGESTAFF,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_AVG,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_MAX,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_TIMES_MIN,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_VOLUME,
					CountsSubCategoryEnum.MESSAGE_COMPLETION_WITHIN_TARGET,
					CountsSubCategoryEnum.MESSAGE_ESCALATION,
//					CountsSubCategoryEnum.MESSAGE_MANAGEMENT_BY_USER_TYPE,
//					CountsAndTrendsFieldEnum.MESSAGE_STATUS_SUMMARY,
					CountsSubCategoryEnum.MESSAGE_STATUS_IN_PROGRESS,
					CountsSubCategoryEnum.MESSAGE_STATUS_READ,
					CountsSubCategoryEnum.MESSAGE_STATUS_UNREAD,
					CountsSubCategoryEnum.MESSAGE_THREADS,
					CountsSubCategoryEnum.MESSAGE_TYPES_APPOINTMENT,
					CountsSubCategoryEnum.MESSAGE_TYPES_GENERAL,
					CountsSubCategoryEnum.MESSAGE_TYPES_MEDICATION,
					CountsSubCategoryEnum.MESSAGE_TYPES_TEST,
					CountsSubCategoryEnum.MESSAGE_TYPES_EDUCATION,
					CountsSubCategoryEnum.OPTED_IN_PATIENTS,
					CountsSubCategoryEnum.OPTED_OUT_PATIENTS,
					CountsSubCategoryEnum.OUTBOUND_MESSAGE_VOLUME,
					//CountsSubCategoryEnum.SM_HEALTHCARE_TEAMS,
					CountsSubCategoryEnum.TOTAL_MESSAGE_VOLUME,
					CountsSubCategoryEnum.UNIQUE_PATIENT_SENDERS,
					CountsSubCategoryEnum.UNIQUE_TEAM_MEMBERS_SENDERS };
			break;
		}
		
		//Sort the list of items.
		List<CountsSubCategoryEnum> ordered = new ArrayList<CountsSubCategoryEnum>();
		for( CountsSubCategoryEnum f: filteredFields){
			ordered.add(f);
		}
		Collections.sort(ordered,CountsSubCategoryEnum.COUNTS_SUBCATEGORY_SORTER);

		return ordered.toArray(new CountsSubCategoryEnum[]{});
	}
	
	
	public static synchronized Object[] getSequenceForLists(RoleScopeEnum role) {
		if( !listsSequencesMap.containsKey(role) ) {
			listsSequencesMap.put(role,RotateListUtil.rotate(COLUMNS,filterLists(role)));
		}
		return listsSequencesMap.get(role); 
	}
	
	public static ListsSubCategoryEnum[] filterLists(RoleScopeEnum role) {
		ListsSubCategoryEnum[] filteredFields = null;
		switch(role){
		case NATIONAL:
			filteredFields = new ListsSubCategoryEnum[] {
				ListsSubCategoryEnum.SM_HEALTHCARE_TEAMS,
		};
			break;
		case VISN:
			filteredFields = new ListsSubCategoryEnum[] {
			ListsSubCategoryEnum.BLOCKED_PATIENTS,
			ListsSubCategoryEnum.SM_HEALTHCARE_TEAMS
			};
			break;
		case FACILITY:
			filteredFields = new ListsSubCategoryEnum[] {
			ListsSubCategoryEnum.ACTION_PENDING_PATIENTS,
			ListsSubCategoryEnum.ASSOCIATED_PATIENTS,
			ListsSubCategoryEnum.BLOCKED_PATIENTS,
			ListsSubCategoryEnum.CPRS_TIU_PROGRESS_NOTE_FAILURE,
			ListsSubCategoryEnum.OPTED_IN_PATIENTS,
			ListsSubCategoryEnum.OPTED_OUT_PATIENTS,
			ListsSubCategoryEnum.SM_HEALTHCARE_TEAM_MEMBERS,
			ListsSubCategoryEnum.SM_HEALTHCARE_TEAMS
			};
			break;
		}
		return filteredFields;
	}
	
//	public static void main(String arg[]) {
//		System.out.println(RotateListUtil.rotate(3,ReportHelper.filterLists(RoleScopeEnum.FACILITY)));
//		System.out.println(RotateListUtil.rotate(3,ReportHelper.filterLists(RoleScopeEnum.VISN)));
//		System.out.println(RotateListUtil.rotate(3,ReportHelper.filterLists(RoleScopeEnum.NATIONAL)));
//		System.out.println(ReportHelper.filterCountsAndTrends(RoleScopeEnum.VISN).length);
//		System.out.println(ReportHelper.filterCountsAndTrends(RoleScopeEnum.NATIONAL).length);
//		System.out.println(ReportHelper.filterCountsAndTrends(RoleScopeEnum.FACILITY).length);
//	}
	
}
