package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.sm.enumeration.ListsSubCategoryEnum;
import gov.va.med.mhv.sm.model.report.ListsResults;
import gov.va.med.mhv.sm.model.report.ListsResultsDetails;
import gov.va.med.mhv.sm.util.DateUtils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListsReport extends BaseFilterReport {
	private static final long serialVersionUID = 1L;
	public static final String SHOW_POPUP = ListsReport.class.getName()+"SHOW_POPUP";

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ListsReport.class);

	// The results can be stored in any object type, as long as the
	// getReportResults and getCsv methods match
	//
	private List<Integer> reportContent = new ArrayList<Integer>();

	private Collection<ListsResults> result = null;

	@Override
	public void prepare() throws Exception {
		super.prepare();
		// Stuff anything necessary on request for jsp
		getRequest().setAttribute("subCategories", ReportHelper.filterLists(role));
		getRequest().setAttribute("subCategoriesSeq", ReportHelper.getSequenceForLists(role));
	}

	@SuppressWarnings("unchecked")
	protected void reconstructParameters() {
		super.reconstructParameters();
		if (getSessionAttribute(getSessionVariableName(this.getClass(), "reportContent")) != null) {
			reportContent = (List<Integer>) getSessionAttribute(getSessionVariableName(this.getClass(), "reportContent"));
		}
	}

	protected void persistParameters() {
		super.persistParameters();
		setSessionAttribute(getSessionVariableName(this.getClass(), "reportContent"), reportContent);
	}

	protected boolean isAllVisnAllowed() {
		return false;
	}

	protected boolean isOneVisnAllowed() {
		return false;
	}

	protected BaseReports getReportResults() {
		CollectionServiceResponse<ListsResults> response = null;
		Map<Integer, ListsSubCategoryEnum> fieldMap = new TreeMap<Integer, ListsSubCategoryEnum>();
		for (Integer id : getReportContent()) {
			fieldMap.put(id, ListsSubCategoryEnum.valueOf(id.intValue()));
		}
		List<ListsSubCategoryEnum> fields = new ArrayList<ListsSubCategoryEnum>();
		fields.addAll(fieldMap.values());

		response = getReportsService().runListsReport(fields, getFilterType(),
				getMainFilterId(), getFilterIds());

		//Reset the filter for sub-category each time a report is created
		removeSessionAttribute(ListsSubCategoryFilter.SUB_CATEGORY_FILTER_LISTS);

		result = response.getCollection();
		setSessionAttribute(REPORT_RESULTS_DATA, result);
		return this;
	}

	public String getCsv() {
		StringBuffer sb = new StringBuffer();
		ListsResults one = null;
		for (ListsResults l : result) {
			one = l;
			break;
		}

		sb.append("This report was generated on " + one.getEndDateFormatted()+ "\n");
		sb.append("\"Report Parameters:  ");
		sb.append("Type: " + "List");
		sb.append(", Filter: " + one.getFacilityTitle());
		sb.append("\"\n");

		Integer current = (Integer) getSessionAttribute(ListsSubCategoryFilter.SUB_CATEGORY_FILTER_LISTS);
		int subCategoryFilterId = -1;
		if (current != null) {
			subCategoryFilterId = current.intValue();
		}

		for (ListsResults oneResult : result) {
			//Sort underlying details
			oneResult.sortListsResultsDetails();

			// Make a table for each detail section
			sb.append("\n");
			sb.append("\nVISN,FACILITY," + oneResult.getFilterTitle().toUpperCase() + " NAME\n");

			for (ListsSubCategoryEnum oneSubcategory : oneResult.getSubCategoriesSorted()) {
				if (subCategoryFilterId != -1 && oneSubcategory.getId() != subCategoryFilterId) {
					continue; // Subfilter
				}

				ListsResultsDetails d = oneResult.getListResultsDetailsForSubcategory(oneSubcategory);

				sb.append(oneResult.getVisnTitle() + ",\"" + oneResult.getFacilityTitle() + "\",\"" + d.getDescription() + "\",");
				int count = 0;
				for (String p : d.getFieldsList()) {
					sb.append(p);
					if( ++count<d.getFieldsList().size()) {
						sb.append(",");
					} else {
						count=0;
					}
				}
				//sb.append("\n");
				if(d.getSize() == 0) {
					sb.append("\n").append(",,").append(oneSubcategory.getName()).append(",None found\n");
				}
				for (int row = 0; row < d.getSize(); row++) {
					if (row == 0) {
						sb.append("\n").append(",,").append(oneSubcategory.getName()).append(",");
					} else {
						sb.append(",,,");
					}

					int size = d.getFieldsList().size();
					count=0;
					for (String p : d.getFieldsList()) {
						int fld = d.getFieldPosition(p);
						String value = d.getValue(fld, row) == null ? "-" : d.getValue(fld, row);
						value = "\""+value+"\"";   //Fix for CR1824
						if (value.contains(".")) {
							DecimalFormat formatter = new DecimalFormat("#0.00");
							try {
								value = formatter.format(new Double(value));
							} catch (NumberFormatException e) {
							}// Probably not a number value
						}
						sb.append(value);
						if( ++count<size ) {
							sb.append(",");
						} else {
							count=0;
						}
					}
					sb.append("\n");
				}
			}
			sb.append("\n");
		}

		sb.append("\n").append("LEGEND").append("\n");
		sb.append("Subcategory,Description").append("\n");
		for (ListsResults oneResult : result) {
			for(ListsSubCategoryEnum oneSubcategory: oneResult.getSubCategoriesSorted()) {
				if( subCategoryFilterId != -1 && oneSubcategory.getId() != subCategoryFilterId ) {
					continue;		//Subfilter
				}
			 	sb.append(oneSubcategory.getName()).append(",").append(oneSubcategory.getLongDescription()).append("\n");
			}
			break;
		}

		return sb.toString();
	}

	@Override
	protected boolean reportParametersValid() {
		boolean result = super.reportParametersValid();

		if (reportContent == null || reportContent.size() == 0) {
			result = false;
			addActionError("Please check at least one 'Subcategory' checkbox");
		}

		return result;
	}

	public List<Integer> getReportContent() {
		return reportContent;
	}

	public void setReportContent(List<Integer> reportContent) {
		this.reportContent = reportContent;
	}

	public void setOkSubmit( String value ) {
		setSessionAttribute(SHOW_POPUP,value);
	}

	public String getOkSubmit() {
		String b = (String)getSessionAttribute(SHOW_POPUP);
		return (b!=null?"true":"false");
	}

	public String getCsvFilename() {
		String date = DateUtils.formatDate(new Date(),DateUtils.ENGLISH_DATE_DASH);
		return "SM_Report_list_"+date+".csv";
	}

}
