package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.sm.model.report.CountsResults;
import gov.va.med.mhv.sm.model.report.CountsResultsDetails;

import java.util.Date;
import java.util.Map;

import org.jfree.data.general.DefaultPieDataset;

import de.laures.cewolf.DatasetProducer;

public class GraphPieDatasetProducer implements DatasetProducer {
	private static final long serialVersionUID = -7908688651473471158L;

	CountsResults c;

	int subCategoryFilter;

	Double zero = new Double(0);

	int period;

	public void setCountsResultsDetails(CountsResults c, int period,
			int subCategoryFilter) {
		this.c = c;
		this.subCategoryFilter = subCategoryFilter;
		this.period = period;
	}

	public Object produceDataset(Map params) {
		final String[] categories = c.getCountsResultsDetailsNames().toArray(
				new String[] {});
		DefaultPieDataset ds = new DefaultPieDataset();

		for (int i = 0; i < categories.length; i++) {
			CountsResultsDetails d = c.getCountsResultsDetails().get(i);
			String val = d.getValue(period, c.getSubCategoryPosition(
					subCategoryFilter).intValue());
			Double valInt = zero;
			if (val != null && val.length() != 0)
				valInt = Double.valueOf(val);
			// if( valInt != 0 )
			ds.setValue(categories[i], valInt);
		}
		return ds;
	}

	public String getProducerId() {
		return "PieDataProducer";
	}

	public boolean hasExpired(Map params, Date since) {
		return true;
	}
}
