package gov.va.med.mhv.sm.web.reports;

import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Map;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;

import de.laures.cewolf.ChartPostProcessor;

public class GraphBarPostProcessor implements ChartPostProcessor {
	public void processChart(Object chart, Map args) {
		JFreeChart jfreeChart = (JFreeChart) chart;

		// Setting up category label lines to 2 since i am having long category
		// labels. such as Clinician Team Member.
		jfreeChart.getCategoryPlot().getDomainAxis()
				.setMaximumCategoryLabelLines(2);
		jfreeChart.getCategoryPlot().getDomainAxis().setTickLabelsVisible(true);
		jfreeChart.getCategoryPlot().getDomainAxis().setTickMarksVisible(true);

		jfreeChart.getCategoryPlot().setDomainGridlinesVisible(true);
		jfreeChart.getCategoryPlot().setDomainGridlinePosition(
				CategoryAnchor.END);

		jfreeChart.getCategoryPlot().setNoDataMessage("No Data");

		if (jfreeChart.getLegend() != null)
			jfreeChart.getLegend()
					.setItemFont(new Font("Arial", Font.PLAIN, 9));

		// Real magic for interval settings starts from here..
		NumberAxis a_NumberAxis = (NumberAxis) jfreeChart.getCategoryPlot()
				.getRangeAxis();
		// final DecimalFormat formatter = new DecimalFormat("0.##%");
		if (a_NumberAxis.getUpperBound() < 7.0) {
			final DecimalFormat formatter = new DecimalFormat("0");
			a_NumberAxis.setTickUnit(new NumberTickUnit(1, formatter));
		}
	}
}