package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.CountsSubCategoryEnum;
import gov.va.med.mhv.sm.enumeration.ReportingCountsTypeEnum;
import gov.va.med.mhv.sm.enumeration.ReportingPeriodEnum;
import gov.va.med.mhv.sm.model.report.CountsResults;
import gov.va.med.mhv.sm.model.report.CountsResultsDetails;
import gov.va.med.mhv.sm.util.DateUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CountsTrendsReport extends BaseDateRangeReport {
	private static final long serialVersionUID = 1L;

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(CountsTrendsReport.class);

	// The results can be stored in any object type, as long as the
	// getReportResults and getCsv methods match
	//
	private List<Integer> reportContent = new ArrayList<Integer>();

	private CountsResults result = null;

	@Override
	public void prepare() throws Exception {
		super.prepare();
		ReportingCountsTypeEnum link = (ReportingCountsTypeEnum) getSessionAttribute(CountsTrendsSwitch.SWITCH);
		if (link == null) {
			setSessionAttribute(CountsTrendsSwitch.SWITCH, ReportingCountsTypeEnum.COUNTS);
		}

		// Stuff anything necessary on request for jsp
		getRequest().setAttribute("subCategories", ReportHelper.filterCountsAndTrends(role));
		getRequest().setAttribute("subCategoriesSeq", ReportHelper.getSequenceForCountsAndTrends(role));
	}

	@SuppressWarnings("unchecked")
	protected void reconstructParameters() {
		super.reconstructParameters();
		if (getSessionAttribute(getSessionVariableName(this.getClass(),	"reportContent")) != null) {
			reportContent = (List<Integer>) getSessionAttribute(getSessionVariableName(this.getClass(), "reportContent"));
		}
	}

	protected void persistParameters() {
		super.persistParameters();
		setSessionAttribute(getSessionVariableName(this.getClass(), "reportContent"), reportContent);
	}

	public String resetParameters() {
		removeSessionAttribute(getSessionVariableName(this.getClass(),"reportContent"));
		removeSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
		removeSessionAttribute(CountsTrendsSwitch.SWITCH);
		return super.resetParameters();
	}

	protected BaseReports getReportResults() {
		ServiceResponse<CountsResults> response = null;
		Map<Integer, CountsSubCategoryEnum> fieldMap = new TreeMap<Integer, CountsSubCategoryEnum>();
		for (Integer id : getReportContent()) {
			fieldMap.put(id, CountsSubCategoryEnum.valueOf(id.intValue()));
		}
		List<CountsSubCategoryEnum> fields = new ArrayList<CountsSubCategoryEnum>();
		fields.addAll(fieldMap.values());

		ReportingPeriodEnum period = getPeriodSelected();

		if (log.isInfoEnabled()) {
			log.info("Start Date:" + getStartDate());
			log.info("End Date:" + getEndDate());
		}

		response = getReportsService().runCountsReport(getStartDate(),
				getEndDate(), period, fields, getFilterType(),
				getMainFilterId(), getFilterIds());

		result = response.getPayload();
		setSessionAttribute(REPORT_RESULTS_DATA, result);

		//Reset the filter for sub-category each time a report is created
		removeSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);

		return this;
	}

	public String getCsv() {
		StringBuffer sb = new StringBuffer();

		sb.append("This report was generated on "+ result.getFormattedRunDate()+"\n");
		sb.append("\"Report Parameters:  ");
		sb.append("Type: " + ReportingCountsTypeEnum.TRENDS.getName());
		sb.append(", Period: " + result.getPeriod());
		sb.append(", Date Range: " + result.getStartDateFormatted() +" - "+ result.getEndDateFormatted() );
		sb.append(", Filter: " + result.getFilterTitle());
		sb.append("\"\n");

		Integer current = (Integer) getSessionAttribute(gov.va.med.mhv.sm.web.reports.CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
		int subCategoryFilterId = -1;
		if (current != null) {
			subCategoryFilterId = current.intValue();
		}
		int sections = 0;
		for (CountsResultsDetails d : result.getCountsResultsDetails()) {
			if (sections == 0) {
				sb.append("VISN,FACILITY," + result.getFilterTitle().toUpperCase() + " NAME\n");
				sections++;
			}
			sb.append(d.getVisnName() + "," + d.getFacilityName() + "," + "\""+d.getDescription()+"\"" +",");


			int per = 0;
			for (String p : result.getFormattedPeriods()) {
				sb.append("\""+ p +"\""+ (per != result.getPeriods().size() - 1 ? "," : "\n"));
				per++;
			}
			int cat = 0;
			for (gov.va.med.mhv.sm.enumeration.CountsSubCategoryEnum c : result.getSubCategoriesSorted()) {
				// Only process "counts" type of sub-categories
				if (c.isCounts() == false) {
					continue;
				}

				// Subfilter
				if (subCategoryFilterId != -1 && c.getId() != subCategoryFilterId) {
					continue;
				} else if (subCategoryFilterId != -1 && c.getId() == subCategoryFilterId) {
					cat = result.getSubCategoryPosition(subCategoryFilterId).intValue();
				} else {
					cat = result.getSubCategoryPosition(c.getId()).intValue();
				}
				sb.append(",," + c.getDescription()+",");
				per = 0;
				for (String p : result.getPeriods()) {
					//per = result.getPeriodPosition(p);
					sb.append((d.getValue(per, cat) == null ? "-" : d.getValue(per, cat)));
					sb.append((per != result.getPeriods().size() - 1 ? "," : "\n"));
					per++;
				}
			}
		}

		sb.append("\n\n").append("LEGEND").append("\n");
		sb.append("Subcategory,Description").append("\n");
		for(CountsSubCategoryEnum oneSubcategory: result.getSubCategoriesSorted()) {
			if( subCategoryFilterId != -1 && oneSubcategory.getId() != subCategoryFilterId ) {
				continue;		//Subfilter
			}
		 	sb.append(oneSubcategory.getDescription()).append(",").append(oneSubcategory.getLongDescription()).append("\n");
		}

		return sb.toString();
	}

	@Override
	protected boolean reportParametersValid() {
		boolean result = super.reportParametersValid();

		if (reportContent == null || reportContent.size() == 0) {
			result = false;
			addActionError("Please check at least one 'Subcategory' checkbox");
		}

		return result;
	}

	public List<Integer> getReportContent() {
		return reportContent;
	}

	public void setReportContent(List<Integer> reportContent) {
		this.reportContent = reportContent;
	}

	public String preserveParameters() {
		//Reset the type of output selected and any filter (when entering from the "Select Report" panel.
		removeSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
		removeSessionAttribute(CountsTrendsSwitch.SWITCH);
		return super.preserveParameters();
	}

	public String getCsvFilename() {
		ReportingCountsTypeEnum type = (ReportingCountsTypeEnum) getSessionAttribute(CountsTrendsSwitch.SWITCH);
		String name = type.getName().toLowerCase();
		String date = DateUtils.formatDate(new Date(),DateUtils.ENGLISH_DATE_DASH);
		return "SM_Report_"+name+"_"+date+".csv";
	}

	@Override
	public boolean isShowInactiveTriageGroups() {
		return true;
	}
}
