package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.sm.enumeration.ReportingFilterTypeEnum;
import gov.va.med.mhv.sm.enumeration.RoleScopeEnum;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.report.ResultKey;
import gov.va.med.mhv.sm.model.report.SelectElement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseFilterReport extends BaseReports {
	private static final long serialVersionUID = 1L;

	private static final Log log = LogFactory.getLog(BaseFilterReport.class);

	private String selectedFilter;

	private Administrator admin;
	protected RoleScopeEnum role = null;
	
	private List<SelectElement> filters = new ArrayList<SelectElement>();
	
	@Override
	public void prepare() throws Exception {
		super.prepare();
		admin = getCurrentUser(); 
		
		if ( admin.isNational() ) {
			role = RoleScopeEnum.NATIONAL;
		} else if ( ! admin.getVisns().isEmpty() ) {
			role = RoleScopeEnum.VISN;
		} else {
			role = RoleScopeEnum.FACILITY;
		}
		
		filters = setViewableFilters(role);
	}

	
	protected void reconstructParameters() {
		super.reconstructParameters();
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"selectedFilter"))!=null) {
			selectedFilter = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"selectedFilter"));
		}
	}
	
	protected void persistParameters(){
		super.persistParameters();
		setSessionAttribute(getSessionVariableName(this.getClass(),"selectedFilter"),selectedFilter);
	}
	
	
	public List<SelectElement> getViewableFilters() {
		return filters;
	}
	
	protected boolean isAllVisnAllowed() {
		return true;
	}
	
	protected boolean isOneVisnAllowed() {
		return true;
	}
	
	/**
	 * TEAM:
	 *    ALL T:{station number}
	 *    T:{team id}|F:{station number}
	 * FACILITY:
	 *    ALL F:{visnid}
	 *    F: {station number}|V:{visnid}
	 * VISN:
	 *    V: {visnid}
	 * 
	 * 
	 * @param role
	 * @return
	 */
	
	private List<SelectElement> setViewableFilters( RoleScopeEnum role ) {
		List<SelectElement> tmpFilters = new ArrayList<SelectElement>();
		tmpFilters.add(new SelectElement("-- Select Team, Facility, or VISN  --", "-1"));
		Collection<Facility> visns;
		switch(role) {
		case NATIONAL:
			visns = getAdministeredVisns();
			if(isOneVisnAllowed()) {
				for( Facility v: visns ) {
					tmpFilters.add( new SelectElement(String.valueOf(v.getName()), "V:"+String.valueOf(v.getId())) );
				}
			}
			if( isAllVisnAllowed() && visns.size()>0)
				tmpFilters.add( new SelectElement("ALL VISNS", "ALL V:") );
			
			for( Facility v: visns ) {
				Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
				for( Facility f: facilities ) {
					tmpFilters.add( new SelectElement(String.valueOf(v.getName()) + ":" + f.getName(), "F:"+String.valueOf(f.getId()) +"|V:" + v.getId()));
				}
				if(facilities.size()>0)
					tmpFilters.add( new SelectElement("ALL FACILITIES "+ v.getName(), "ALL F:"+ v.getId()) );
			}
			break;
			case VISN:
			visns = getAdministeredVisns();
			if(isOneVisnAllowed()) {
				for( Facility v: visns ) {
					tmpFilters.add( new SelectElement(v.getName(), "V:"+String.valueOf(v.getId())) );
				}
			}
			for( Facility v: visns ) {
				Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
				for( Facility f: facilities ) {
					tmpFilters.add( new SelectElement("VISN " + f.getVisn() + ":" + f.getName(), "F:"+String.valueOf(f.getId()) +"|V:" + v.getId()));
				}
				if(facilities.size()>0)
					tmpFilters.add( new SelectElement("ALL FACILITIES "+ v.getName(), "ALL F:"+ v.getId()) );
			}
			break;
			case FACILITY:
			visns = getAdministeredVisns();
			for( Facility v: visns ) {
				Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
				for( Facility f: facilities ) {
					Collection<TriageGroup> teams = getTriageGroupService().getTriageGroupsForStation(f.getStationNumber()).getCollection(); 
					//Collection<TriageGroup> deletedTeams = getTriageGroupService().getInActiveTriageGroupsForStation(f.getStationNumber()).getCollection();
					
					for( TriageGroup team: teams ) {
						tmpFilters.add( new SelectElement("VISN " + f.getVisn() + ":" + f.getName()+":"+team.getName(), "T:"+String.valueOf(team.getId())+"|F:" + f.getId()) );
					}
					
					/*if( isShowInactiveTriageGroups() ) {
						for( TriageGroup team: deletedTeams ) {
							tmpFilters.add( new SelectElement("VISN " + f.getVisn() + ":" + f.getName()+":"+team.getName()+" (Deleted)", "T:"+String.valueOf(team.getId())+"|F:" + f.getId()) );
						}
					}*/
					
					if( teams.size()>0)
						tmpFilters.add( new SelectElement("ALL TEAMS " + f.getName(), "ALL T:"+ f.getId()) );
				}
			}
			break;
		
		}
		
		return tmpFilters;
	}

	@Override
	protected boolean reportParametersValid() {
		boolean result = true;
		
		if ( selectedFilter == null || selectedFilter.equals("") || selectedFilter.equals("-1")){
			result = false;
			addActionError("Please select a filter");
		}
		
		result &= super.reportParametersValid();
		return result;
	}
	
	protected void getReportParameters() {
		super.getReportParameters();
	}

	public String getSelectedFilter() {
		return selectedFilter;
	}

	public void setSelectedFilter(String selectedFilter) {
		this.selectedFilter = selectedFilter;
		parseIdForFilter(selectedFilter);
	}
	
	private void parseIdForFilter(String param) {
		//May want to cache the previous results and only if it changes
		//Then refresh the data for performance.
		super.clearFilterIds();
		Long oneEl = null;
		Long oneElParent = null;
		ResultKey rk = null;
		
		if( param.startsWith("ALL V:") || param.startsWith("V:")) {
			//All Visns
			if( param.startsWith("V:") ) {
				oneEl = Long.parseLong(param.substring(2));
				super.setFilterType(ReportingFilterTypeEnum.VISN);
			} else {
				rk = new ResultKey("none", "none");
				super.setFilterType(ReportingFilterTypeEnum.ALL_VISNS);
			}
			
			Collection<Facility> visns = getAdministeredVisns();
			for( Facility v: visns ) {
				if( oneEl == null || (oneEl != null && v.getId().equals(oneEl)) ) {
					if(rk == null) rk = new ResultKey(String.valueOf(v.getId()), v.getName());
					super.getFilterIds().add(new ResultKey(String.valueOf(v.getId()), v.getName()));
				}
			}
			
			super.setMainFilterId(rk);
			
		}
		else if( param.startsWith("ALL F:") || param.startsWith("F:") ) {
			//Parse VisnId
			Collection<Facility> visns = getAdministeredVisns();
			
			if( param.startsWith("F:") ) {
				oneEl = Long.parseLong(param.substring(2,param.indexOf('|')));
				oneElParent = Long.parseLong(param.substring(param.indexOf('|')+3));
				for( Facility v: visns ) {
					if( v.getId().equals(oneElParent)) {
						Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
						for( Facility f: facilities ) {
							if( f.getId().equals(oneEl) ) {
								super.setMainFilterId(new ResultKey(String.valueOf(v.getId()), v.getName()));
								super.getFilterIds().add(new ResultKey(f.getStationNumber(), f.getName()));
								break;
							}
						}
					}
				}
				super.setFilterType(ReportingFilterTypeEnum.FACILITY);
			} else {
				Long visnId = Long.parseLong(param.substring(6));
				//All facilities
				for( Facility v: visns ) {
					if( v.getId().equals(visnId) ) {
						super.setMainFilterId(new ResultKey(String.valueOf(visnId), v.getName()));
						Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
						for( Facility f: facilities ) {
							super.getFilterIds().add(new ResultKey(f.getStationNumber(), f.getName()));
						}
						break;
					}
				}
				super.setFilterType(ReportingFilterTypeEnum.ALL_FACILITIES);
			}
			
		}
		else if( param.startsWith("ALL T:") || param.startsWith("T:")) {
			//All teams
			Collection<Facility> visns = getAdministeredVisns();
			
			if( param.startsWith("T:") ) {
				oneEl = Long.parseLong(param.substring(2,param.indexOf('|')));
				oneElParent = Long.parseLong(param.substring(param.indexOf('|')+3));
				for( Facility v: visns ) {
					Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
					for( Facility f: facilities ) {
						if( f.getId().equals(oneElParent) ) {
							super.setMainFilterId(new ResultKey(String.valueOf(f.getStationNumber()), f.getName()));
							Collection<TriageGroup> teams = getTriageGroupService().getTriageGroupsForStation(f.getStationNumber()).getCollection(); 
							for( TriageGroup team: teams ) {
								if( team.getId().equals(oneEl) ) {
									super.getFilterIds().add(new ResultKey(String.valueOf(team.getId()), team.getName()));
								}
							}
							
							/*if( isShowInactiveTriageGroups() ) {
								log.info("***ADDING DELETED TRIAGE GROUPS");
								Collection<TriageGroup> deletedTeams = getTriageGroupService().getInActiveTriageGroupsForStation(f.getStationNumber()).getCollection(); 
								for( TriageGroup team: deletedTeams ) {
									if( team.getId().equals(oneEl) ) {
										super.getFilterIds().add(new ResultKey(String.valueOf(team.getId()), team.getName() + " (Deleted)"));
									}
								}
							}*/
							break;
						}
					}
				}
				super.setFilterType(ReportingFilterTypeEnum.TEAM);
			}
			else {
				Long facId = Long.parseLong(param.substring(6));
				for( Facility v: visns ) {
					Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
					for( Facility f: facilities ) {
						if( facId.equals(f.getId())) {
							super.setMainFilterId(new ResultKey(f.getStationNumber(), f.getName()));
							Collection<TriageGroup> teams = getTriageGroupService().getTriageGroupsForStation(f.getStationNumber()).getCollection(); 
							for( TriageGroup team: teams ) {
								super.getFilterIds().add(new ResultKey(String.valueOf(team.getId()), team.getName()));
							}
							/*if( isShowInactiveTriageGroups() ) {
								log.info("***ADDING DELETED TRIAGE GROUPS");
								Collection<TriageGroup> deletedTeams = getTriageGroupService().getInActiveTriageGroupsForStation(f.getStationNumber()).getCollection(); 
								for( TriageGroup team: deletedTeams ) {
									super.getFilterIds().add(new ResultKey(String.valueOf(team.getId()), team.getName() + " (Deleted)"));
								}
							}*/
							break;
						}
					}
				}
				super.setFilterType(ReportingFilterTypeEnum.ALL_TEAMS);
			}
		}
		
		if(log.isInfoEnabled()) {
			log.info("Filter type for reports:" + super.getFilterType().getName());
			log.info("Sub Filter Id's for report: " + super.getFilterIds());
			log.info("Main Filter Id's for report: " + super.getMainFilterId());
		}
	}
	
	public boolean isShowInactiveTriageGroups() {
		return false;
	}

	public String resetParameters() {
		removeSessionAttribute(getSessionVariableName(this.getClass(),"selectedFilter"));
		return super.resetParameters();
	}
}

