package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.sm.enumeration.ReportingPeriodEnum;
import gov.va.med.mhv.sm.enumeration.RoleScopeEnum;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.util.PeriodsHelper;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseDateRangeReport extends BaseFilterReport {

	private static final long serialVersionUID = 1L;
	private String periodYearStart;
	private String periodYearEnd;
	private String periodQuarterStart;
	private String periodQuarterEnd;
	private String periodWeekStart;
	private String periodWeekEnd;
	private String periodMonthStart;
	private String periodMonthEnd;
	private String periodDateStart;
	private String periodDateEnd;

	private Administrator admin;
	protected RoleScopeEnum role = null;
	
	protected ReportingPeriodEnum periodSelected = null;
	protected Long periodSelectedLong = null;
	
	private static final Log log = LogFactory.getLog(BaseDateRangeReport.class);
	
	public Long dayPeriodLong = ReportingPeriodEnum.DAY.getId();
	public Long weekPeriodLong = ReportingPeriodEnum.WEEK.getId();
	public Long monthPeriodLong = ReportingPeriodEnum.MONTH.getId();
	public Long quarterPeriodLong = ReportingPeriodEnum.QUARTER.getId();
	public Long yearPeriodLong = ReportingPeriodEnum.FISCAL_YEAR.getId();
	
	private ReportingPeriodEnum DEFAULT_PERIOD = ReportingPeriodEnum.DAY;
	
	private Map<ReportingPeriodEnum, Date> startDates = new HashMap<ReportingPeriodEnum, Date>();
	private Map<ReportingPeriodEnum, Date> endDates = new HashMap<ReportingPeriodEnum, Date>();
	
	private static final Integer MONTHS_24_IN_MS = 24 * 60 * 60 * 1000;
	private static final Integer QUARTERS_8_IN_MONTHS = 3 * 8;
	private static final Integer MONTHS_12 = 12;
	private static final Integer DAYS_60 =60;
	private static final Integer WEEKS_26_IN_DAYS = 26*7;
	
	@Override
	public void prepare() throws Exception {
		super.prepare();
		admin = getCurrentUser(); 
		
		if ( admin.isNational() ) {
			role = RoleScopeEnum.NATIONAL;
		} else if ( ! admin.getVisns().isEmpty() ) {
			role = RoleScopeEnum.VISN;
		} else {
			role = RoleScopeEnum.FACILITY;
		}
	}
	
	protected void reconstructParameters() {
		super.reconstructParameters();
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodYearStart"))!=null) {
			periodYearStart = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodYearStart"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodYearEnd"))!=null) {
			periodYearEnd = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodYearEnd"));
		}
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterStart"))!=null) {
			periodQuarterStart = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterStart"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterEnd"))!=null) {
			periodQuarterEnd = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterEnd"));
		}
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekStart"))!=null) {
			periodWeekStart = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekStart"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekEnd"))!=null) {
			periodWeekEnd = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekEnd"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthStart"))!=null) {
			periodMonthStart = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthStart"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthEnd"))!=null) {
			periodMonthEnd = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthEnd"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodDateStart"))!=null) {
			periodDateStart = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodDateStart"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodDateEnd"))!=null) {
			periodDateEnd = (String)getSessionAttribute(getSessionVariableName(this.getClass(),"periodDateEnd"));
		} 
		if(getSessionAttribute(getSessionVariableName(this.getClass(),"periodSelected"))!=null) {
			periodSelected = (ReportingPeriodEnum)getSessionAttribute(getSessionVariableName(this.getClass(),"periodSelected"));
		}
		
	}
	
	protected void persistParameters(){
		super.persistParameters();
		
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodYearStart"),periodYearStart);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodYearEnd"),periodYearEnd);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterStart"),periodQuarterStart);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterEnd"),periodQuarterEnd);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekStart"),periodWeekStart);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekEnd"),periodWeekEnd);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthStart"),periodMonthStart);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthEnd"),periodMonthEnd);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodDateStart"),periodDateStart);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodDateEnd"),periodDateEnd);
		setSessionAttribute(getSessionVariableName(this.getClass(),"periodSelected"),periodSelected);
	}
	
	@Override
	protected boolean reportParametersValid() {
		boolean result = true;
		
		switch( getPeriodSelected() ) {
			case DAY: 
				//check dates
				if( periodDateStart == null || periodDateStart.equals("") || periodDateStart.equals("-1") ){
					addActionError("Please enter a start date");
					result = false;
				}else {
					try {
						PeriodsHelper.getStartDateForDateParameter(periodDateStart);
					} catch (ParseException e) {
						addActionError("Please enter a valid start date");
						result = false;
					}
				}
				if( periodDateEnd == null || periodDateEnd.equals("") || periodDateEnd.equals("-1")){
					addActionError("Please enter an end date");
					result = false;
				} else {
					try {
						PeriodsHelper.getEndDateForDateParameter(periodDateEnd);
					} catch (ParseException e) {
						addActionError("Please enter a valid end date");
						result = false;
					}	
				}
				
				//Check that end date is prior to today
				try {
					Calendar e = Calendar.getInstance();
					e.setTime(PeriodsHelper.getEndDateForDateParameter(periodDateEnd));
					e.set(Calendar.HOUR, 0);
		        	e.set(Calendar.MINUTE, 0);
		        	e.set(Calendar.SECOND, 0);
		        	e.set(Calendar.MILLISECOND, 0);
		        	e.set(Calendar.AM_PM, 0);
		        	
					Calendar today = Calendar.getInstance();
					
					Calendar yesterday = Calendar.getInstance();
					yesterday.set(Calendar.HOUR, 0);
					yesterday.set(Calendar.MINUTE, 0);
					yesterday.set(Calendar.SECOND, 0);
					yesterday.set(Calendar.MILLISECOND, 0);
					yesterday.set(Calendar.AM_PM, 0);
					yesterday.add(Calendar.HOUR,-24);
					if( e.after(yesterday) ) {
						addActionError("Please select an end date that is before " + DateUtils.getEnglishDate(today.getTime())+".");
						result = false;
					}
				} catch(Exception e) {
					//Nothing to check
				}
				
				//Check Range limits:
				try {
					Calendar s = Calendar.getInstance();
					s.setTime(PeriodsHelper.getStartDateForDateParameter(periodDateStart));
					Calendar e = Calendar.getInstance();
					e.setTime(PeriodsHelper.getEndDateForDateParameter(periodDateEnd));
					
					if(isGreaterThanDate(s,e,Calendar.DATE, DAYS_60)) { //60 days
						addActionError("Please select a date range that does not exceed 60 days");
						result = false;
					}
				} catch (ParseException e) {
					//Already caught in prior validation
				}
				
			break;
			case WEEK:
				//check weeks
				if( periodWeekStart == null || periodWeekStart.equals("") || periodWeekStart.equals("-1")){
					addActionError("Please select a start week");
					result = false;
				}
				if( periodWeekEnd == null || periodWeekEnd.equals("") || periodWeekEnd.equals("-1")){
					addActionError("Please select an end week");
					result = false;
				}
				
				//Check Range limits:
				try {
					Calendar s = Calendar.getInstance();
					s.setTime(PeriodsHelper.getStartDateForDateParameter(periodWeekStart));
					Calendar e = Calendar.getInstance();
					e.setTime(PeriodsHelper.getEndDateForDateParameter(periodWeekEnd));
					if( isGreaterThanDate(s,e,Calendar.DATE,WEEKS_26_IN_DAYS)) { //26 weeks
						addActionError("Please select a week range that does not exceed 26 weeks");
						result = false;
					}
				} catch (ParseException e) {
					//Already caught in prior validation
				}
			break;
			case MONTH:
				//Check Months
				if( periodMonthStart == null || periodMonthStart.equals("") || periodMonthStart.equals("-1")){
					addActionError("Please select a start month");
					result = false;
				}
				if( periodMonthEnd == null || periodMonthEnd.equals("") || periodMonthEnd.equals("-1")){
					addActionError("Please select an end month");
					result = false;
				}
				
				//Check Range limits:
				try {
					Calendar s = Calendar.getInstance();
					s.setTime(PeriodsHelper.getStartDateForDateParameter(periodMonthStart));
					Calendar e = Calendar.getInstance();
					e.setTime(PeriodsHelper.getEndDateForDateParameter(periodMonthEnd));
					if( isGreaterThanDate(s,e,Calendar.MONTH,MONTHS_12)) {
						addActionError("Please select a month range that does not exceed 12 months");
						result = false;
					}
				} catch (ParseException e) {
					//Already caught in prior validation
				}
			break;
			case QUARTER:
				//Check Quarters
				if( periodQuarterStart == null || periodQuarterStart.equals("") || periodQuarterStart.equals("-1")){
					addActionError("Please select a start quarter");
					result = false;
				}
				if( periodQuarterEnd == null || periodQuarterEnd.equals("") || periodQuarterEnd.equals("-1")){
					addActionError("Please select an end quarter");
					result = false;
				}
				
				//Check Range limits:
				try {
					Calendar s = Calendar.getInstance();
					s.setTime(PeriodsHelper.getStartDateForDateParameter(periodQuarterStart));
					Calendar e = Calendar.getInstance();
					e.setTime(PeriodsHelper.getEndDateForDateParameter(periodQuarterEnd));
					if( isGreaterThanDate(s,e,Calendar.MONTH,QUARTERS_8_IN_MONTHS)) { //8 quarters
						addActionError("Please select a quarter range that does not exceed 8 quarters");
						result = false;
					}
				} catch (ParseException e) {
					//Already caught in prior validation
				}
			break;
			case FISCAL_YEAR:
				//Check Quarters
				if( periodYearStart == null || periodYearStart.equals("") || periodYearStart.equals("-1")){
					addActionError("Please select a start fiscal year");
					result = false;
				}
				if( periodYearEnd == null || periodYearEnd.equals("") || periodYearEnd.equals("-1")){
					addActionError("Please select an end fiscal year");
					result = false;
				}
				//Check Range limits:
				try {
					Calendar s = Calendar.getInstance();
					Calendar e = Calendar.getInstance();
					s.setTime(PeriodsHelper.getStartDateForDateParameter(periodYearStart));
					e.setTime(PeriodsHelper.getEndDateForDateParameter(periodYearEnd));
					if( isGreaterThanDate(s,e,Calendar.YEAR,3)) { //3 years
						addActionError("Please select a fiscal year range that does not exceed 3 fiscal years");
						result = false;
					}
				} catch (ParseException e) {
					//Already caught in prior validation
				}
			break;
		}
		result &= super.reportParametersValid();
		return result;
	}
	
	private boolean isGreaterThanDate( Calendar cal1, Calendar cal2, int type, int value ) {
		boolean result = false;
        
        switch( type ) {
	        case Calendar.YEAR:
	        	cal1.set(Calendar.DAY_OF_MONTH,1);
	        	cal1.set(Calendar.HOUR, 0);
	        	cal1.set(Calendar.MINUTE, 0);
	        	cal1.set(Calendar.SECOND, 0);
	        	cal1.set(Calendar.MILLISECOND, 0);
	        	cal1.set(Calendar.AM_PM, 0);
	        	cal2.set(Calendar.DAY_OF_MONTH,1);
	        	cal2.set(Calendar.HOUR, 0);
	        	cal2.set(Calendar.MINUTE, 0);
	        	cal2.set(Calendar.SECOND, 0);
	        	cal2.set(Calendar.MILLISECOND, 0);
	        	cal2.set(Calendar.AM_PM, 0);
	        	cal1.add(Calendar.YEAR,value);
	        	result = cal2.after(cal1) || cal2.equals(cal1);
	        	if( log.isInfoEnabled() ) {
	        		log.info("++Start: " + DateUtils.getEnglishDate(cal1.getTime()) + ", End: " + DateUtils.getEnglishDate(cal2.getTime()) +"; is greater than?" + result);
	            }
	        	break;
	        case Calendar.MONTH:
	        	cal1.set(Calendar.DAY_OF_MONTH,1);
	        	cal1.set(Calendar.HOUR, 0);
	        	cal1.set(Calendar.MINUTE, 0);
	        	cal1.set(Calendar.SECOND, 0);
	        	cal1.set(Calendar.MILLISECOND, 0);
	        	cal1.set(Calendar.AM_PM, 0);
	        	cal2.set(Calendar.DAY_OF_MONTH,1);
	        	cal2.set(Calendar.HOUR, 0);
	        	cal2.set(Calendar.MINUTE, 0);
	        	cal2.set(Calendar.SECOND, 0);
	        	cal2.set(Calendar.MILLISECOND, 0);
	        	cal2.set(Calendar.AM_PM, 0);
	        	
	        	cal1.add(Calendar.MONTH,value);
	        	result = cal2.after(cal1) || cal2.equals(cal1);
	        	if( log.isInfoEnabled() ) {
	        		log.info("++Start: " + DateUtils.getEnglishDate(cal1.getTime()) + ", End: " + DateUtils.getEnglishDate(cal2.getTime()) +"; is greater than?" + result);
	            }
	        	break;
	        case Calendar.DATE:
	        	cal1.add(Calendar.DATE,value);
	        	long diff = cal2.getTimeInMillis() - cal1.getTimeInMillis();
	        	long diffDays = diff / (MONTHS_24_IN_MS);
	        	result = diffDays>0;
	        	if( log.isInfoEnabled() ) {
	        		log.info("++Start: " + DateUtils.getEnglishDate(cal1.getTime()) + ", End: " + DateUtils.getEnglishDate(cal2.getTime()) + ", Diff=" + diffDays +"; is greater than?" + result);
	            }
	        	break;
        }

        return result;
	}
	
	
	protected void getReportParameters() {
		//Setup Start and End date based on the selected period
		if(log.isInfoEnabled()) {
			log.info("startDates:"+ startDates);
			log.info("endDates:"+ endDates);
			log.info("periodSelected:"+periodSelected);
			log.info("startDate:"+startDates.get(periodSelected));
			log.info("endDate:"+endDates.get(periodSelected));
		}
		
		setStartDate(startDates.get(periodSelected));
		setEndDate(endDates.get(periodSelected));
		super.getReportParameters();
	}

	public ReportingPeriodEnum getPeriodSelected() {
		return periodSelected;
	}

	public void setPeriodSelected(ReportingPeriodEnum enumPeriod) {
		this.periodSelected = enumPeriod;
	}

	//Exposed as a Long apapter for parameter of Enum type
	public Long getPeriodSelectedLong() {
		return (this.periodSelected==null?DEFAULT_PERIOD.getId():this.periodSelected.getId());
	}
	public void setPeriodSelectedLong(Long periodSelectedLong) {
		this.periodSelected = ReportingPeriodEnum.valueOf(periodSelectedLong);
	}
	
	public String getPeriodDateEnd() {
		return periodDateEnd;
	}

	public void setPeriodDateEnd(String periodDateEnd) {
		this.periodDateEnd = periodDateEnd;
		try {
			endDates.put(ReportingPeriodEnum.DAY,PeriodsHelper.getEndDateForDateParameter(periodDateEnd));
		} catch (ParseException e) {
			//Caught in validation step not in the setter (Too early for exception)
		}
	}
	
	public String getPeriodDateStart() {
		return periodDateStart;
	}

	public void setPeriodDateStart(String periodDateStart) {
		this.periodDateStart = periodDateStart;
		try {
			startDates.put(ReportingPeriodEnum.DAY,PeriodsHelper.getStartDateForDateParameter(periodDateStart));
		} catch (ParseException e) {
			//Caught in validation
		}
	}

	public String getPeriodMonthEnd() {
		return periodMonthEnd;
	}

	public void setPeriodMonthEnd(String periodMonthEnd) {
		this.periodMonthEnd = periodMonthEnd;
		endDates.put(ReportingPeriodEnum.MONTH,PeriodsHelper.getEndDateForMonthParameter(periodMonthEnd));
	}

	public String getPeriodMonthStart() {
		return periodMonthStart;
	}

	public void setPeriodMonthStart(String periodMonthStart) {
		this.periodMonthStart = periodMonthStart;
		startDates.put(ReportingPeriodEnum.MONTH,PeriodsHelper.getStartDateForMonthParameter(periodMonthStart));
	}

	public String getPeriodQuarterEnd() {
		return periodQuarterEnd;
	}

	public void setPeriodQuarterEnd(String periodQuarterEnd) {
		this.periodQuarterEnd = periodQuarterEnd;
		endDates.put(ReportingPeriodEnum.QUARTER,PeriodsHelper.getEndDateForQuarterParameter(periodQuarterEnd));
	}

	public String getPeriodQuarterStart() {
		return periodQuarterStart;
	}

	public void setPeriodQuarterStart(String periodQuarterStart) {
		this.periodQuarterStart = periodQuarterStart;
		startDates.put(ReportingPeriodEnum.QUARTER,PeriodsHelper.getStartDateForQuarterParameter(periodQuarterStart));
	}

	public String getPeriodWeekEnd() {
		return periodWeekEnd;
	}

	public void setPeriodWeekEnd(String periodWeekEnd) {
		this.periodWeekEnd = periodWeekEnd;
		endDates.put(ReportingPeriodEnum.WEEK,PeriodsHelper.getEndDateForWeekParameter(periodWeekEnd));
	}

	public String getPeriodWeekStart() {
		return periodWeekStart;
	}

	public void setPeriodWeekStart(String periodWeekStart) {
		this.periodWeekStart = periodWeekStart;
		startDates.put(ReportingPeriodEnum.WEEK,PeriodsHelper.getStartDateForWeekParameter(periodWeekStart));
	}

	public String getPeriodYearEnd() {
		return periodYearEnd;
	}

	public void setPeriodYearEnd(String periodYearEnd) {
		this.periodYearEnd = periodYearEnd;
		endDates.put(ReportingPeriodEnum.FISCAL_YEAR,PeriodsHelper.getEndDateForYearParameter(periodYearEnd));
	}

	public String getPeriodYearStart() {
		return periodYearStart;
	}

	public void setPeriodYearStart(String periodYearStart) {
		this.periodYearStart = periodYearStart;
		startDates.put(ReportingPeriodEnum.FISCAL_YEAR,PeriodsHelper.getStartDateForYearParameter(periodYearStart));
	}
	
	public Long getDayPeriodLong() {
		return dayPeriodLong;
	}

	public Long getMonthPeriodLong() {
		return monthPeriodLong;
	}

	public Long getQuarterPeriodLong() {
		return quarterPeriodLong;
	}

	public Long getWeekPeriodLong() {
		return weekPeriodLong;
	}
	
	public Long getYearPeriodLong() {
		return yearPeriodLong;
	}
	
	public String preserveParameters() {
		return super.preserveParameters();
	}
	
	public String resetParameters() {
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodYearStart"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodYearEnd"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterStart"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodQuarterEnd"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekStart"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodWeekEnd"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthStart"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodMonthEnd"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodDateStart"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodDateEnd"));
		removeSessionAttribute(getSessionVariableName(this.getClass(),"periodSelected"));

		return super.resetParameters();
	}
	
//	public static void main(String a[]) {
//			Calendar s = Calendar.getInstance();
//			Calendar e = Calendar.getInstance();
//			System.out.println(DateUtils.getEnglishDate(s.getTime()));
//			s.add(Calendar.MONTH,12);  //Date is 60 days limit
//			System.out.println(DateUtils.getEnglishDate(s.getTime()));
//			e.add(Calendar.DATE,12);
//			
//			System.out.println( "Result: " +  );
//			
//			System.out.println(DateUtils.getEnglishDate(s.getTime()) + " -- " + DateUtils.getEnglishDate(e.getTime()));
//		
//	}
	
}

