package gov.va.med.mhv.sm.web.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.sm.enumeration.UserTypeEnum;

public class ExpiredSessionFilter implements Filter {
	
	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ExpiredSessionFilter.class);
	
	private String sessionTimeOutPage;
	private FilterConfig filterConfig = null;

	public void destroy() {
		this.filterConfig = null;
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {

		HttpServletRequest hreq = (HttpServletRequest)request;
		HttpServletResponse hresp = (HttpServletResponse)response;
		HttpSession session = hreq.getSession();
		
		//log.info("ExpiredSessionFilter .....");
		
		if (filterConfig == null) {
			return;
		}

		boolean isSessionExpired = false;

		if (filterConfig.getInitParameter("SessionTimeOutPage") != null) {
			sessionTimeOutPage = filterConfig.getInitParameter("SessionTimeOutPage");
		} else {
			sessionTimeOutPage = "sessionExpired.jsp";
		}

		String requestedPath = hreq.getRequestURI();

		log.debug("Requested path: " + requestedPath);
		
		// Process only if request's not for logon page, StyleSheet or images
		if (!requestedPath.endsWith("index.jsp") // dummy login page
			// session timeout page defined in web.xml
				&& !requestedPath.endsWith(sessionTimeOutPage)
			// test admin login page
				&& !requestedPath.endsWith("adminTest.action")
			// Default session expiration page
				&& !requestedPath.endsWith("sessionExpired.jsp")
			// Action URL invoked from MHV admin portal
				&& !requestedPath.endsWith("loginAdminIntegration.action"))
		{
			// If there's a session open
			if (session.getAttribute("user") == null) {
					isSessionExpired = true;
			} 
		}

		if (isSessionExpired) {
			//log.info("session is expired....  redirecting to session expiration page");
			HttpServletResponseWrapper wrapper = new HttpServletResponseWrapper(hresp);
			wrapper.sendRedirect(wrapper.encodeRedirectURL(hreq.getContextPath() + "/" + sessionTimeOutPage));
		} else {
			//log.info("session is not expired");
			chain.doFilter(request, response);
		}
	}

	public void init(FilterConfig filterConfig) throws ServletException {
		this.filterConfig = filterConfig;
	}
}
